package de.duehl.swing.ui.components.selections.tools;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;

/**
 * Diese Klasse stellt den Editor einer ComboBox dar, dessen Hintergrundfarbe man ändern kann.
 *
 * @version 1.01     2024-06-11
 * @author Christian Dühl
 */

public class BackgroundColorChangingComboBoxEditor implements ComboBoxEditor {

    /** Das Textfeld in dem der Text angezeigt wird. */
    private final JTextField textField;

    /** Konstruktor mit anfänglich weißer Hintergrundfarbe. */
    public BackgroundColorChangingComboBoxEditor() {
        this(Color.WHITE);
    }

    /**
     * Konstruktor.
     *
     * @param background
     *            Anfängliche Hintergrundfarbe.
     */
    public BackgroundColorChangingComboBoxEditor(Color background) {
        textField = new JTextField();
        textField.setBackground(background);
    }

    @Override
    public Component getEditorComponent() {
        return textField;
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject != null) {
            textField.setText(anObject.toString());
        }
    }

    @Override
    public Object getItem() {
        return textField.getText();
    }

    @Override
    public void selectAll() {
        textField.selectAll();
    }

    @Override
    public void addActionListener(ActionListener l) {
        textField.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        textField.removeActionListener(l);
    }

    /** Setzt die Hintergrundfarbe des Textfeldes. */
    public void setBackground(Color background) {
        textField.setBackground(background);
    }

    /** Getter für das Textfeld. */
    public JTextField getTextField() {
        return textField;
    }

}
