package de.duehl.swing.ui.dialogs.logging;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.swing.ui.tables.BasicTableColumnModel;

/**
 * Diese Klasse stellt das Column-Modell der Tabelle dar, in der das Logfile angezeigt wird.
 *
 * @version 1.02     2017-03-30
 * @author Christian Dühl
 */

public class LogFileColumnModel extends BasicTableColumnModel {

    private static final long serialVersionUID = 1L;

    public LogFileColumnModel() {
        addMinMaxWidthColumn(85, "Datum");
        addMinMaxWidthColumn(70, "Zeit");
        addMinWidthColumn(150, "Klasse");
        addMinWidthColumn(150, "Methode");
        addMinMaxWidthColumn(75, "Zeile");
        addWidthColumnWithSpecialMinWidth(400, "Nachricht", 90);
    }

}
