package de.duehl.swing.ui.dialogs.values;

import java.awt.Image;
import java.awt.Point;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.colors.Colorizer;

/**
 * Diese Klasse öffnet einen Dialog zum Eingeben eines Bereichs zweier nicht-negativer ganzer
 * Zahlen.
 *
 * @version 1.02     2017-09-11
 * @author Christian Dühl
 */

public class EnterRangeDialog extends EnterTwoValuesDialog {

    /** Wird zurückgegeben, wenn der Dialog nicht erfolgreich beendet wurde. */
    public static final int NO_MIN_OR_MAX_VALUE = -1;

    /**
     * Konstruktor.
     *
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     * @param programImage
     *            Icon für den Dialog.
     * @param dialogTitle
     *            Titel des Dialogs.
     * @param firstPresetting
     *            Vorgabe die im ersten Eingabefeld angezeigt werden soll.
     * @param secondPresetting
     *            Vorgabe die im zweiten Eingabefeld angezeigt werden soll.
     */
    public EnterRangeDialog(Point parentLocation, Image programImage, String dialogTitle,
            int firstPresetting, int secondPresetting) {
        this(null, parentLocation, programImage, dialogTitle, firstPresetting, secondPresetting);
    }

    /**
     * Konstruktor.
     *
     * @param colorizer
     *            Farbverwaltung für die Gui.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     * @param programImage
     *            Icon für den Dialog.
     * @param dialogTitle
     *            Titel des Dialogs.
     * @param firstPresetting
     *            Vorgabe die im ersten Eingabefeld angezeigt werden soll.
     * @param secondPresetting
     *            Vorgabe die im zweiten Eingabefeld angezeigt werden soll.
     */
    public EnterRangeDialog(Colorizer colorizer, Point parentLocation, Image programImage,
            String dialogTitle, int firstPresetting, int secondPresetting) {
        super(colorizer, parentLocation, programImage, dialogTitle,
                "Minimalwert", Integer.toString(firstPresetting),
                "Maximalwert", Integer.toString(secondPresetting));
    }

    @Override
    protected void apply() {
        String value1 = getFirstValue();
        String value2 = getSecondValue();
        if (value1.isEmpty()) {
            applyFailure("Der erste Wert darf nicht leer sein.");
        }
        else if (value2.isEmpty()) {
            applyFailure("Der zweite Wert darf nicht leer sein.");
        }
        else if (!NumberString.isDigitSequence(value1)) {
            applyFailure("Der erste Wert darf nur aus Ziffern bestehen.");
        }
        else if (!NumberString.isDigitSequence(value2)) {
            applyFailure("Der zweite Wert darf nur aus Ziffern bestehen.");
        }
        else {
            int v1 = Integer.parseInt(value1);
            int v2 = Integer.parseInt(value2);
            if (v1 <= v2) {
                applyOk();
            }
            else {
                applyFailure("Der erste Wert muss kleiner gleich dem zweiten Wert sein.");
            }
        }
    }

    /** Getter für das Minimum des Bereichs. */
    public int getMinValue() {
        if (isApplyOk()) {
            return Integer.parseInt(getFirstValue());
        }
        else {
            return NO_MIN_OR_MAX_VALUE;
        }
    }

    /** Getter für das Maximum des Bereichs. */
    public int getMaxValue() {
        if (isApplyOk()) {
            return Integer.parseInt(getSecondValue());
        }
        else {
            return NO_MIN_OR_MAX_VALUE;
        }
    }

}
