package de.duehl.swing.ui.dragndrop;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.dnd.DropTargetListener;

import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

/**
 * Diese Klasse stellt einen die DropTargetListener dar, der für normale JTextFields verwendet
 * wird. Bei Drag & Drop wird der originaltext entfernt, wenn dahinter eingefügt wird.
 *
 * @version 1.01     2021-07-27
 * @author Christian Dühl
 */

public class StandardTextComponentDropTargetListener extends TextEditingDropTargetListener
        implements DropTargetListener {

    /**
     * Konstruktor.
     *
     * @param textComponent
     *            Das Textfeld, zu dem der Listener hinzugefügt wird.
     */
    public StandardTextComponentDropTargetListener(JTextComponent textComponent) {
        super(textComponent);
    }

    /**
     * In dieser Methode wird der eingefügte Text bearbeitet.
     *
     * @param draggedText
     *            Der gezogene Text.
     */
    @Override
    protected void editContent(String draggedText) {
        SwingUtilities.invokeLater(() -> editContentLater(draggedText));
    }

    private void editContentLater(String draggedText) {
        String text = DragNDropManagerHelper.prepareHtmlDraggedString(draggedText);
        textComponent.setText(text);
    }

}
