package de.duehl.swing.ui.dragndrop;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.dnd.DropTargetListener;

import javax.swing.JTextField;

/**
 * Dieses Klasse stellt einen die DropTargetListener dar, der für normale
 * JTextFields verwendet wird. Bei Drag & Drop wird der originaltext entfernt,
 * wenn dahinter eingefügt wird.
 *
 *
 * Ist ursprünglich von 2015 und momentan ungenutzt...
 *
 * @version 1.01     2021-07-27
 * @author Christian Dühl
 */

public class TextFieldDropTargetListener extends TextEditingDropTargetListener implements
        DropTargetListener {

    public TextFieldDropTargetListener(final JTextField field) {
        super(field);
    }

    /**
     * In dieser Methode wird der eingefügte Text bearbeitet.
     *
     * @param draggedText
     *            Der gezogene Text.
     */
    @Override
    protected void editContent(String draggedText) {
        String text;

//        text = field.getText();

        //System.out.println("text:" + text);
        //System.out.println("entered:" + entered); // true
        //System.out.println("oldContent:" + oldContent);

//        /* Alten Inhalt vorn entfernen: */
//        if (text.startsWith(oldContent)) {
//            text = text.substring(oldContent.length());
//        }
//        /* Falls man mitten in den String einfügt, lässt sich jetzt nicht mehr feststellen,
//         * an welcher Stelle der neue sitzt.
//         */
//
//        /*
//         * Besser wäre es, den alten Text vorher komplett zu löschen. Aber das ist hier nicht gut
//         * möglich. Man kommt nämlich nicht mit diesen Methoden an die Stelle, wo der Mausklick
//         * über "unserem" JTextField ausgelöst wurde, der Drop-Text aber noch nicht eingefügt
//         * wurde.
//         *
//         * Löscht man ihn etwa in dragEnter(), wird der Inhalt auch gelöscht, wenn dann auf einem
//         * anderen Textfeld die Maus losgelassen wird.
//         */

        text = draggedText;

        text = text.trim();

        textComponent.setText(text);
    }

}
