package de.duehl.swing.ui.elements.watch;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.datetime.time.watch.Watch;

/**
 * Diese Klasse stellt ein Label dar, das den auf ihm angezeigten Uhr automatisch aktualisiert.
 *
 * @version 1.01     2021-03-17
 * @author Christian Dühl
 */

public class WatchLabel extends WatchBaseLabel {

    private static final long serialVersionUID = 1L;

    /** Konstruktor ohne Text vor und nach der Uhrzeit. */
    public WatchLabel() {
        this("", new Watch(), "");
    }

    /**
     * Konstruktor mit Text vor der Uhrzeit.
     *
     * @param startText
     *            Text vor der Uhrzeit.
     */
    public WatchLabel(String startText) {
        this(startText, new Watch(), "");
    }

    /**
     * Konstruktor mit Text vor und nach der Uhrzeit.
     *
     * @param startText
     *            Text vor der Uhrzeit.
     * @param endText
     *            Text nach der Uhrzeit.
     */
    public WatchLabel(String startText, String endText) {
        this(startText, new Watch(), endText);
    }

    /**
     * Konstruktor mit Text vor und nach der Uhrzeit sowie eigener Countdown-Uhr, die übergeben
     * wird.
     *
     * @param startText
     *            Text vor der Uhrzeit.
     * @param watch
     *            Uhr, deren Zeit angezeigt wird.
     * @param endText
     *            Text nach der Uhrzeit.
     */
    public WatchLabel(String startText, Watch watch, String endText) {
        super(startText, watch, endText);
    }

    /** Stringrepräsentation. */
    @Override
    public String toString() {
        return "WatchLabel [" + createWatchLabelText() + "]";
    }

}
