package de.duehl.swing.ui.filter.method;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

/**
 * Diese Klasse repräsentiert die Filtermethode 'alle Datensätze' (ALL).
 *
 * @version 1.01     2020-11-05
 * @author Christian Dühl
 */

public class MethodAll<Data> implements Method<Data> {

    /** Erzeugt den Filter mit allen Datensätzen. */
    @Override
    public List<Integer> buildFilter(List<Data> list) {
        List<Integer> numberList = new ArrayList<Integer>();

        for (int index = 0; index < list.size(); ++index)
            numberList.add(index + 1);

        return numberList;
    }

}
