package de.duehl.swing.ui.io.lock.ui;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Enum-Klasse stellt eine Antwort des Dialogs zur Anzeige, dass ein Lock nicht erhalten
 * werden konnte, dar.
 * Es gibt drei Auswahlmöglichkeiten:
 *     - Erneuter Versuch das Lock zu erhalten ohne dieses vorher zu entfernen
 *     - Entfernen des Locks und Wiederholung des Schrittes.
 *     - Abbruch des Programms.
 *
 * @version 1.01     2021-02-09
 * @author Christian Dühl
 */

public enum NoLockGainedDialogAnswer {

    RETRY_WITHOUT_REMOVING_LOCK,
    REMOVE_LOCK_AND_RETRY,
    CANCEL,

}
