package de.duehl.swing.ui.pages;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;

/**
 * Dieses Interface steht für ein Objekt, das für die Anzeige von Daten auf Seiten, zwischen denen
 * man blättern kann, aus einem Datenobjekt eine GUI-Komponente erzeugt.
 *
 * @version 1.01     2024-01-22
 * @author Christian Dühl
 */

public interface PanelFromDataCreator<DataType> {

    /** Erstellt aus dem übergebenen Datensatz die Anzeige für die Gui. */
    Component createDatasetUi(DataType data);

}
