package de.duehl.swing.ui.start;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/*
 * Original ist von hier:
 * https://docs.oracle.com/javase/tutorial/uiswing/components/textarea.html
 * https://docs.oracle.com/javase/tutorial/uiswing/examples/components/TextAreaDemoProject/src/components/TextAreaDemo.java
 *
 * Verbessert von mir.
 */

import javax.swing.*;
import javax.swing.text.JTextComponent;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.text.autocompletion.AutoCompletionTextComponentExtender;

import java.util.*;

import java.awt.BorderLayout;

public class TextFieldDemo extends JFrame {

    private static final long serialVersionUID = 1L;

    private static final List<String> AUTO_COMPLETE_WORDS = CollectionsHelper.buildListFrom(
            "spark",
            "special",
            "spectacles",
            "spectacular",
            "swing",
            "Äpfel",
            "Äpfelblubb"
            );

    public TextFieldDemo() {
        super("JTextField Demo");
        setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        initComponents();
    }

    private void initComponents() {
        JLabel headLabel = new JLabel("Try typing 'spectacular' or 'Swing'...");

        JTextField textField = new JTextField();
        textField.setColumns(50);
        extendAutoCompletion(textField);

        JScrollPane scrollPane = new JScrollPane(textField);

        setLayout(new BorderLayout());

        add(headLabel, BorderLayout.NORTH);
        add(scrollPane, BorderLayout.CENTER);
        pack();
    }

    private void extendAutoCompletion(JTextComponent textComponent) {
        AutoCompletionTextComponentExtender extender = new AutoCompletionTextComponentExtender(
                textComponent, AUTO_COMPLETE_WORDS);
        extender.changeActivationKeyToSpace();
        extender.doNotInsertSpaceBehindCompletion();
        extender.setMinimalLengthForAutoCompletionStart(1);
        extender.extendAutoCompletion();
    }

    public static void main(String args[]) {
        GuiTools.setNiceLayoutManager();
        new TextFieldDemo().setVisible(true);
    }

}
