package de.duehl.swing.ui.start.card.c.output;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.swing.ui.layout.card.CardGui;
import de.duehl.swing.ui.layout.card.CardLogic;
import de.duehl.swing.ui.layout.card.CardResult;
import de.duehl.swing.ui.start.card.b.work.WorkCardResult;

public class OutputCardLogic extends CardLogic {

    private OutputCardGui gui;
    private WorkCardResult previousResult;

    @Override
    public void setGui(CardGui gui) {
        if (gui instanceof OutputCardGui) {
            this.gui = (OutputCardGui) gui;
        }
        else {
            throw new RuntimeException("Aufruf mit der falschen Gui!");
        }
    }

    @Override
    public void setResultFromPreviousCard(CardResult previousResult) {
        if (previousResult instanceof WorkCardResult) {
            this.previousResult = (WorkCardResult) previousResult;
        }
        else {
            throw new RuntimeException("Aufruf mit dem falschen CardResult!");
        }
    }

    @Override
    public void runWhenShown() {
        boolean odd = previousResult.isOdd();
        if (odd) {
            gui.showOdd();
        }
        else {
            gui.showEven();
        }
    }

    @Override
    public CardResult getResult() {
        // Wird bei der letzten Karte nicht aufgerufen.
        throw new RuntimeException("Darf nicht aufgerufen werden.");
    }

    @Override
    public void quit() {
        // Hier muss nichts gemacht werden, weil es keinen
        // laufenden anderen Thread zur Berechnung gibt.
    }

}
