package de.duehl.swing.ui.start.enter;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.dialogs.values.EnterTwoNotEmptyStringValuesDialog;

public class EnterTwoNotEmptyStringValuesDialogTest {

    public static void main(String[] args) {
        new EnterTwoNotEmptyStringValuesDialogTest();
    }

    /** Konstruktor. */
    public EnterTwoNotEmptyStringValuesDialogTest() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                createGUI();
            }
        });
    }

    private void createGUI() {
        final JFrame frame = new JFrame("EnterTwoNotEmptyStringValuesDialog - Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        JButton runButton = new JButton("Start");
        frame.add(runButton, BorderLayout.CENTER);
        runButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                createDialog(frame);
            }
        });

        frame.setPreferredSize(new Dimension(300, 200));
        frame.setLocation(300, 200);
        frame.pack();
        frame.setVisible(true);
    }

    private void createDialog(JFrame frame) {
        EnterTwoNotEmptyStringValuesDialog dialog = new EnterTwoNotEmptyStringValuesDialog(
                frame.getLocation(), null, "Eingabetest",
                "Bitte geben Sie etwas ein:", "Vorbelegung 1",
                "Bitte geben Sie etwas anderes ein:", "Vorbelegung 2");
        dialog.setVisible(true);
        if (dialog.isApplyOk()) {
            String value1 = dialog.getFirstValue();
            String value2 = dialog.getSecondValue();
            System.out.println("Ausgabe: [" + value1 + ", " + value2 + "]");
        }
        else {
            System.out.println("Abbruch durch den Benutzer.");
        }
    }

}
