package de.duehl.swing.ui.start.progress;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import javax.swing.JLabel;

import de.duehl.basics.system.SystemTools;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.elements.progress.StandardColoredProgressPanel;

public class StandardColoredProgressPanelDemo {

    private static final int NUMBER_OF_TASKS = 20;
    private static final Random RANDOM = new Random();

    private final StandardColoredProgressPanel progressPanel;

    private List<String> taskDescriptions;

    private DemoProgressDialog progressDialog;

    public StandardColoredProgressPanelDemo() {
        GuiTools.setNiceLayoutManager();

        progressPanel = new StandardColoredProgressPanel()
                .setProgressTitle("Fortschritt beim Ausführen von Demo-Aufgaben:")
                .setCountPrefix("Anzahl ausgeführter Aufgaben: ")
                .setTimerPrefix("Laufzeit: ")
                .setActualElementPrefix("Führe aus: ")
                .setActualElementPrefixBeforeStart("Noch nichts ausgeführt.")
                .setActualElementWhenDone("Alle Demo-Aufgaben wurden ausgeführt.")
                .createProgressPanel();
    }

    public void run() {
        createTaskDescriptions();
        progressPanel.initNumberOfTasksToDo(taskDescriptions.size());

        progressDialog = new DemoProgressDialog(progressPanel);
        new Thread(() -> runTasksInOwnThread()).start();
        progressDialog.setVisible(true);
    }

    private void createTaskDescriptions() {
        taskDescriptions = new ArrayList<>();
        for (int number = 1; number <= NUMBER_OF_TASKS; ++number) {
            taskDescriptions.add("Aufgabe " + number);
        }
    }

    private void runTasksInOwnThread() {
        SystemTools.sleep(250); // damit der Dialog Zeit hat, sich aufzubauen bevor es auch schon
                                // los geht.

        progressPanel.startingWithTask();

        for (String taskDescription : taskDescriptions) {
            runTask(taskDescription);
        }

        progressDialog.closeDialog();
    }

    private void runTask(String taskDescription) {
        progressPanel.aboutToExceuteOneTaskSoon(taskDescription);

        int sleepSeconds = 1 + RANDOM.nextInt(3);
        SystemTools.sleepSeconds(sleepSeconds);

        progressPanel.oneTaskDone(taskDescription);
    }

    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();
        StandardColoredProgressPanelDemo demo = new StandardColoredProgressPanelDemo();
        demo.run();
    }

}

class DemoProgressDialog extends NonModalFrameDialogBase {

    private static final int DIALOG_WIDTH = 800;

    private final StandardColoredProgressPanel progressPanel;

    public DemoProgressDialog(StandardColoredProgressPanel progressPanel) {
        super("Fortschritt bei der Bearbeitung von Demo-Aufgaben");
        addClosingWindowListener(() -> {});

        this.progressPanel = progressPanel;

        fillDialog();
    }

    @Override
    protected void populateDialog() {
        add(createDummyLabelForDialogWidth(), BorderLayout.NORTH);
        add(progressPanel.getComponent(), BorderLayout.CENTER);
    }

    private Component createDummyLabelForDialogWidth() {
        JLabel label = new JLabel();
        label.setPreferredSize(new Dimension(DIALOG_WIDTH, 0));
        return label;
    }

}

