package de.duehl.threads;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.Random;

public class BusyRunnable extends ATimableRunnable implements Runnable {

    public BusyRunnable(final int seconds) {
        super(seconds);
    }

    @Override
    protected void tryToRun() throws InterruptedException {
        long start = System.currentTimeMillis();
        boolean running = true;
        Random random = new Random();
        long calculation = 0L;
        while (running) {
            calculation = calculation + random.nextInt(25);
            calculation = calculation > 1000 ? calculation - 1000 : calculation;
            System.out.println("- BusyRunnable Berechnung: " + calculation);

            Thread.sleep(500);
            running = start + seconds * 1000 > System.currentTimeMillis();
        }
        System.out.println("- BusyRunnable beendet");
    }

}
