package de.duehl.twosidecommander.try1.list;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JButton;
import javax.swing.JPanel;

import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.twosidecommander.try1.list.displayer.DemoListDisplayer1;

public class ListTestDemo2WithButton extends NonModalFrameDialogBase {

    private static final String TITLE = "ListTestDemo 1";

    private static final Dimension DIALOG_DIMENSION = new Dimension(1000, 600);


    private DemoListDisplayer1 displayer;

    private boolean hideOrShowMoveButtons;

    public ListTestDemo2WithButton() {
        super(TITLE, DIALOG_DIMENSION);

        displayer = new DemoListDisplayer1();

        fillDialog();
    }

    @Override
    protected void populateDialog() {
        add(displayer.getComponent(), BorderLayout.CENTER);
        add(createButtonPart(), BorderLayout.SOUTH);
    }

    private Component createButtonPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createSwitchMoveButtonsButton(), BorderLayout.EAST);

        return panel;
    }

    private Component createSwitchMoveButtonsButton() {
        JButton button = new JButton("Move-Buttons ein/aus schalten");
        button.addActionListener(e -> switchMoveButtons());
        return button;
    }

    private void switchMoveButtons() {
        hideOrShowMoveButtons = !hideOrShowMoveButtons;
        displayer.showMoveButtonsOnListElements(hideOrShowMoveButtons);
        //repaint();
        pack(); // das macht den Unterschied! TODO Eine entsprechende Lösung ohne Pack finden...
                // oder ich muss es nach unten durchreichen?
    }

    public static void main(String[] args) {
        ListTestDemo2WithButton tester = new ListTestDemo2WithButton();
        tester.setVisible(true);
    }

}
