package de.duehl.vocabulary.japanese.common.persistence.data;

/**
 * Diese Enum steht dafür, ob auf das Abschicken einer leeren Übersetzung reagiert werden soll.
 *
 * @version 1.01     2024-06-13
 * @author Christian Dühl
 */

public enum EmptyTranslationsAcceptance {

    ALWAYS("immer"),
    NOT_IMMEDIATELY("nicht sofort nach der vorigen Abfrage"),
    NEVER("niemals");

    /** Die Beschreibung für den Optionen-Dialog. */
    private final String optionDescription;

    /**
     * Konstruktor.
     *
     * @param description
     *            Die Beschreibung für den Optionen-Dialog.
     */
    private EmptyTranslationsAcceptance(String description) {
        this.optionDescription = description;
    }

    /** Getter für die Beschreibung für den Optionen-Dialog. */
    public String getOptionDescription() {
        return optionDescription;
    }

    /** Erzeugt ein String zum persistenten Speichern der Einstellung. */
    public String toPersistence() {
        return name();
    }

    /** Erzeugt ein Objekt dieser Enum-Klasse aus dem gespeicherten String. */
    public static EmptyTranslationsAcceptance createFromPersistence(String persistence) {
        for (EmptyTranslationsAcceptance acceptance : EmptyTranslationsAcceptance.values()) {
            if (persistence.equals(acceptance.toPersistence())) {
                return acceptance;
            }
        }

        throw new IllegalArgumentException("Zum gespeicherten String '" + persistence
                + "' kann kein EmptyTranslationsAcceptance-Objekt ermittelt werden.");
    }

}
