package de.duehl.vocabulary.japanese.common.ui.resources;

import java.awt.Image;

import de.duehl.swing.ui.resources.IconLoader;

/**
 * Diese Klasse enthält die Kürzel für die Bilddateien, erzeugt einen IconLoader und initialisiert
 * ihn mit den Bildkürzeln und Bildnamen. Es wird erwartet, dass alle Bilder im gleichen Paket wie
 * diese Klasse liegen.
 *
 * @version 1.01     2024-04-11
 * @author Christian Dühl
 */

public class IconDefinitions {

    /** Kürzel für das Bild des Programms. */
    public static final String PROGRAMM_IMAGE = "PROGRAM_IMAGE";

    public static final String VIEW_VOCABULARY = "VIEW_VOCABULARY";
    //public static final String TEST_VOCABULARY = "TEST_VOCABULARY";
    public static final String TEST_VOCABULARY_JAPANESE_TO_GERMAN =
            "TEST_VOCABULARY_JAPANESE_TO_GERMAN";
    public static final String TEST_VOCABULARY_GERMAN_TO_JAPANESE =
            "TEST_VOCABULARY_GERMAN_TO_JAPANESE";
    public static final String SHOW_VOCABULARY_LIST = "SHOW_VOCABULARY_LIST";
    public static final String SHOW_VOCABULARY_SHEET = "SHOW_VOCABULARY_SHEET";
    public static final String DELETE_OWN_LIST = "DELETE_OWN_LIST";
    public static final String EDIT_OWN_LIST = "EDIT_OWN_LIST";
    public static final String IMPORT_OWN_LIST = "IMPORT_OWN_LIST";
    public static final String EXPORT_OWN_LIST = "EXPORT_OWN_LIST";
    public static final String NEW_OWN_LIST = "NEW_OWN_LIST";
    public static final String UMSCHALTER_JAPANISCH_DEUTSCH = "UMSCHALTER_JAPANISCH_DEUTSCH";
    public static final String UMSCHALTER_DEUTSCH_JAPANISCH = "UMSCHALTER_DEUTSCH_JAPANISCH";


    /**
     * Erzeugt einen IconLoader mit allen Bilddefinitionen.
     *
     * @return IconLoader Objekt das das Bild des Programms laden kann.
     */
    public IconLoader createIconLoader() {
        IconLoader iconLoader = new IconLoader(this.getClass(), PROGRAMM_IMAGE);
        //iconLoader.addPictureIdentifier(PROGRAMM_IMAGE, "vokabel-trainer.png");
        iconLoader.addPictureIdentifier(PROGRAMM_IMAGE, "japanisch_deutsch.png");

        //iconLoader.addPictureIdentifier(VIEW_VOCABULARY, "system-search.png");
        iconLoader.addPictureIdentifier(VIEW_VOCABULARY, "Einzelansicht.png");
        //iconLoader.addPictureIdentifier(TEST_VOCABULARY, "internet-group-chat.png");
        iconLoader.addPictureIdentifier(TEST_VOCABULARY_JAPANESE_TO_GERMAN,
                "japanisch_deutsch.png");
        iconLoader.addPictureIdentifier(TEST_VOCABULARY_GERMAN_TO_JAPANESE,
                "deutsch_japanisch.png");
        //iconLoader.addPictureIdentifier(SHOW_VOCABULARY_LIST, "format-justify-fill.png");
        iconLoader.addPictureIdentifier(SHOW_VOCABULARY_LIST, "Listenansicht.png");
        //iconLoader.addPictureIdentifier(SHOW_VOCABULARY_SHEET, "text-x-generic-template.png");
        iconLoader.addPictureIdentifier(SHOW_VOCABULARY_SHEET, "Blattansicht.png");
        //iconLoader.addPictureIdentifier(DELETE_OWN_LIST, "emblem-unreadable.png");
        iconLoader.addPictureIdentifier(DELETE_OWN_LIST, "Delete.png");
        //iconLoader.addPictureIdentifier(EDIT_OWN_LIST, "document-open.png");
        iconLoader.addPictureIdentifier(EDIT_OWN_LIST, "Bearbeiten.png");

        //iconLoader.addPictureIdentifier(IMPORT_OWN_LIST, "folder.png");
        iconLoader.addPictureIdentifier(IMPORT_OWN_LIST, "Import.png");
        //iconLoader.addPictureIdentifier(EXPORT_OWN_LIST, "media-floppy.png");
        iconLoader.addPictureIdentifier(EXPORT_OWN_LIST, "Export.png");

        //iconLoader.addPictureIdentifier(NEW_OWN_LIST, "document-new.png");
        iconLoader.addPictureIdentifier(NEW_OWN_LIST, "Neue_Liste.png");

        iconLoader.addPictureIdentifier(UMSCHALTER_JAPANISCH_DEUTSCH,
                "Unschalter_Japanisch_Deutsch.png");
        iconLoader.addPictureIdentifier(UMSCHALTER_DEUTSCH_JAPANISCH,
                "Unschalter_Deutsch_Japanisch.png");

        return iconLoader;
    }

    public static Image loadProgramImage() {
        IconDefinitions iconDefinitions = new IconDefinitions();
        IconLoader iconLoader = iconDefinitions.createIconLoader();
        return iconLoader.loadProgramIconImage();
    }

}
