package de.duehl.vocabulary.japanese.startup.logic.steps;

import java.util.List;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.io.InternalKanaDataReader;
import de.duehl.vocabulary.japanese.startup.ui.data.MessageAppender;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;

/**
 * Diese Klasse steht für den Schritt zum Einlesen der internen Daten zu den Hiragana und Katakana
 * beim Startup des Vokabeltrainers.
 *
 * @version 1.01     2025-11-24
 * @author Christian Dühl
 */

public class Step14LoadInternalKanaData extends StartupStep {

    /** Das Objekt das zu einem Kana die internen, benutzerabhängigen Daten abrufen kann. */
    private InternalKanaDataRequester internalKanaDataRequester;

    /**
     * Konstruktor.
     *
     * @param step
     *            Der Schritt der durchgeführt wird.
     * @param options
     *            Die Programmoptionen.
     * @param splashScreen
     *            Die grafische Oberfläche beim Start in der die Meldungen angezeigt werden.
     * @param watch
     *            Misst die Laufzeit des gesamten Startups.
     */
    public Step14LoadInternalKanaData(String step, Options options, SplashScreenable splashScreen,
            StopWatch watch) {
        super(step, options, splashScreen, watch);
    }

    /** Führt den eigentlichen Inhalt des Schritts aus. */
    @Override
    protected void runInternalStep() {
        appendMessage("Lade die internen Daten zu Hiragana und Katakana ...");
        InternalKanaDataReader reader = new InternalKanaDataReader((MessageAppender) this);
        reader.read();
        internalKanaDataRequester = reader.getRequester();
        List<String> warningLines = reader.getWarningLines();
        if (!warningLines.isEmpty()) {
            String warningsString = Text.joinWithLineBreak(warningLines);
            warningsInStep(warningsString);
        }
    }

    /**
     * Getter für das Objekt das zu einem Kana die internen, benutzerabhängigen Daten abrufen kann.
     */
    public InternalKanaDataRequester getInternalKanaDataRequester() {
        return internalKanaDataRequester;
    }

}
