package de.duehl.vocabulary.japanese.ui.dialog.table.hiragana;

import de.duehl.swing.ui.tables.BasicTableColumnModel;

/**
 * Diese Klasse stellt das Column-Modell der Tabelle mit den Hiragana dar.
 *
 * @version 1.02     2025-02-02
 * @author Christian Dühl
 */

public class HiraganaTableColumnModel extends BasicTableColumnModel {

    private static final long serialVersionUID = 1L;

    /**
     * Die Tabelle enthält die folgenden Spalten:
     *     - Die laufende Nummer.
     *     - Das Hiragana in UTF-8 Darstellung.
     *     - Die Darstellung in Hepburn.
     *     - Der Untertyp der Hiragana.
     * Außerdem die folgenden Spalten aus den internen Hiragana-Daten:
     *     - Die Anzahl, wie oft das Hiragana getestet wurde.
     *     - Die Anzahl, wie oft das Hiragana erfolgreich getestet wurde.
     *     - Das Datum des letzten Tests.
     *     - Das Datum des letzten erfolgreichen Tests.
     *     - Das Abschneiden bei den letzten Tests.
     *     - Button zum Betrachten der Hiragana mit allen internen Daten
     */
    public HiraganaTableColumnModel() {
        addMinMaxWidthColumn(45, "#");
        addMinWidthColumn(50, "Hiragana");
        addMinWidthColumn(50, "Hepburn");
        addMinWidthColumn(120, "Untertyp");

        addMinMaxWidthColumn(60, "Getestet");
        addMinMaxWidthColumn(50, "richtig");
        addMinMaxWidthColumn(90, "zuletzt getestet");
        addMinMaxWidthColumn(90, "zuletzt richtig");
        addMinWidthColumn(100, "letzte 10 Ergebnisse");
        addMinMaxWidthColumn(80, "Interna");
    }

}
