/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.debug;

import de.duehl.basics.datetime.Timestamp;
import de.duehl.basics.text.Text;
import java.util.List;

public class DebugHelper {
    public static void printStackTrace() {
        DebugHelper.say(DebugHelper.stackTraceToString());
    }

    public static String stackTraceToString() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            stringBuilder.append(stackTraceElement.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static void printStackTraceSmall() {
        System.out.print(DebugHelper.stackTraceToStringSmall());
    }

    public static String stackTraceToStringSmall() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string = stackTraceElement.getClassName();
            if (string.startsWith("java.awt") || string.startsWith("java.security")) continue;
            String string2 = Text.getLastPartAfterDivider(string, ".");
            if (bl) {
                bl = false;
                if (string2.equals("DebugHelper") || string2.equals("Thread")) {
                    bl = true;
                }
            }
            if (bl) continue;
            stringBuilder.append(string2);
            stringBuilder.append(" ");
            stringBuilder.append(stackTraceElement.getMethodName());
            stringBuilder.append("()");
            int n = stackTraceElement.getLineNumber();
            if (n >= 0) {
                stringBuilder.append(" ");
                stringBuilder.append(n);
            }
            stringBuilder.append(" - ");
            String string3 = stackTraceElement.getFileName();
            if (string3 == null) {
                stringBuilder.append("unknown source");
            } else if (n >= 0) {
                stringBuilder.append("(" + string3 + ":" + n + ")");
            } else {
                stringBuilder.append("(" + string3 + ")");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static void say() {
        DebugHelper.say("");
    }

    public static void say(String string) {
        System.out.println(string);
    }

    public static void sayWithoutLineBreak(String string) {
        System.out.print(string);
    }

    public static void sayWithClassAndMethod(String string) {
        String string2 = DebugHelper.buildClassAndMethodMessage(string);
        DebugHelper.say(string2);
    }

    private static String buildClassAndMethodMessage(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[4];
        String string2 = stackTraceElement.getClassName();
        List<String> list = Text.splitByDot(string2);
        String string3 = list.get(list.size() - 1);
        String string4 = stackTraceElement.getMethodName();
        String string5 = "[Zeile " + stackTraceElement.getLineNumber() + "]";
        String string6 = string3 + "#" + string4 + "() " + string5 + ": " + string;
        return string6;
    }

    public static void sayWithClassAndMethodAndTime(String string) {
        String string2 = DebugHelper.buildClassAndMethodMessage(string);
        String string3 = Timestamp.actualDateAndTime(", ");
        DebugHelper.say(string3 + " - " + string2);
    }

    public static void sayWithClassAndMethodAndTimeAndMillis(String string) {
        String string2 = DebugHelper.buildClassAndMethodMessage(string);
        String string3 = Timestamp.actualDateAndTime(", ");
        DebugHelper.say(string3 + " (" + System.currentTimeMillis() + ") - " + string2);
    }

    private static void partLine(int n) {
        for (int i = 0; i < n; ++i) {
            DebugHelper.sayWithoutLineBreak("-");
        }
    }

    public static void line(int n) {
        DebugHelper.partLine(n);
        DebugHelper.say();
    }

    public static void line() {
        DebugHelper.line(80);
    }

    public static void embedTextIntoLine(String string) {
        DebugHelper.embedTextIntoLine(string, 80);
    }

    public static void embedTextIntoLine(String string, int n) {
        int n2 = string.length();
        if (n2 + 4 > n) {
            System.out.println(string);
        } else {
            int n3 = (n - n2 - 2) / 2;
            int n4 = n - n2 - 2 - n3;
            DebugHelper.partLine(n3);
            DebugHelper.sayWithoutLineBreak(" " + string + " ");
            DebugHelper.partLine(n4);
            DebugHelper.say();
        }
    }
}

