/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.html.generation;

import de.duehl.basics.text.html.generation.HtmlBuilder;
import de.duehl.basics.text.html.generation.HtmlHeaderType;

public class SwingHtmlBuilder
extends HtmlBuilder {
    private static final String GREEN = "00A000";
    private static final String ORANGE = "ff6600";
    private static final String RED = "ff0000";

    public SwingHtmlBuilder() {
        this.createContentWithNames();
    }

    public SwingHtmlBuilder appendLocalColoredRedP(String string) {
        return this.appendLocalColoredP(string, RED);
    }

    public SwingHtmlBuilder appendLocalColoredOrangeP(String string) {
        return this.appendLocalColoredP(string, ORANGE);
    }

    public SwingHtmlBuilder appendLocalColoredGreenP(String string) {
        return this.appendLocalColoredP(string, GREEN);
    }

    public SwingHtmlBuilder appendLocalColoredP(String string, String string2) {
        return this.appendLocalColoredTag("p", string, string2);
    }

    private SwingHtmlBuilder appendLocalColoredTag(String string, String string2, String string3) {
        String string4 = "style=\"" + this.createColorStylePart(string3) + "\"";
        this.appendInTagWithParameters(string, string2, string4);
        return this;
    }

    private String createColorStylePart(String string) {
        return "color:#" + string;
    }

    private String createBackgroundColorStylePart(String string) {
        return "background:#" + string;
    }

    private SwingHtmlBuilder appendLocalColoredTagWithId(String string, String string2, String string3, String string4) {
        String string5 = "style=\"" + this.createColorStylePart(string4) + "\"";
        this.appendInTagWithParameters(string, string2, "id=\"" + string3 + "\"", string5);
        return this;
    }

    public SwingHtmlBuilder appendLocalColoredH1(String string, String string2) {
        ++this.numberOfH1;
        return this.appendLocalColoredHeader(HtmlHeaderType.H1, string, string2);
    }

    public SwingHtmlBuilder appendLocalColoredH2(String string, String string2) {
        ++this.numberOfH2;
        return this.appendLocalColoredHeader(HtmlHeaderType.H2, string, string2);
    }

    public SwingHtmlBuilder appendLocalColoredH3(String string, String string2) {
        ++this.numberOfH3;
        return this.appendLocalColoredHeader(HtmlHeaderType.H3, string, string2);
    }

    public SwingHtmlBuilder appendLocalColoredH4(String string, String string2) {
        ++this.numberOfH4;
        return this.appendLocalColoredHeader(HtmlHeaderType.H4, string, string2);
    }

    public SwingHtmlBuilder appendLocalColoredH5(String string, String string2) {
        ++this.numberOfH5;
        return this.appendLocalColoredHeader(HtmlHeaderType.H5, string, string2);
    }

    public SwingHtmlBuilder appendLocalColoredH6(String string, String string2) {
        ++this.numberOfH6;
        return this.appendLocalColoredHeader(HtmlHeaderType.H6, string, string2);
    }

    private SwingHtmlBuilder appendLocalColoredHeader(HtmlHeaderType htmlHeaderType, String string, String string2) {
        this.appendTopLinkIfNeccessary(htmlHeaderType);
        String string3 = this.generateHeaderId(htmlHeaderType);
        this.appendHeaderAndInsertLineBreakIfNotFirstContent(htmlHeaderType, string, string3);
        String string4 = htmlHeaderType.getHtmlTagName();
        this.appendLocalColoredTagWithId(string4, string, string3, string2);
        return this;
    }

    public SwingHtmlBuilder appendLocalColoredLi(String string, String string2) {
        return this.appendLocalColoredTag("li", string, string2);
    }

    public SwingHtmlBuilder appendLocalColoredRedSpan(String string) {
        return this.appendLocalColoredSpan(string, RED);
    }

    public SwingHtmlBuilder appendLocalColoredOrangeSpan(String string) {
        return this.appendLocalColoredSpan(string, ORANGE);
    }

    public SwingHtmlBuilder appendLocalColoredGreenSpan(String string) {
        return this.appendLocalColoredSpan(string, GREEN);
    }

    public SwingHtmlBuilder appendLocalColoredSpan(String string, String string2) {
        return this.appendLocalColoredTag("span", string, string2);
    }

    public SwingHtmlBuilder appendTdLocalRight(String string) {
        String string2 = "style=\"text-align:right;\"";
        this.appendInTagWithParameters("td", string, string2);
        return this;
    }

    public SwingHtmlBuilder appendLocalLargeP(String string) {
        String string2 = "style=\"font-size:large\"";
        this.appendInTagWithParameters("p", string, string2);
        return this;
    }

    public SwingHtmlBuilder appendLocalSmallP(String string) {
        String string2 = "style=\"font-size:x-small\"";
        this.appendInTagWithParameters("p", string, string2);
        return this;
    }

    public SwingHtmlBuilder appendLocalTtSpan(String string) {
        String string2 = "style=\"font-family: monospace;\"";
        this.appendInTagWithParameters("span", string, string2);
        return this;
    }

    @Override
    public SwingHtmlBuilder createContentWithNames() {
        super.createContentWithNames();
        return this;
    }

    @Override
    public SwingHtmlBuilder hideTopLinks() {
        super.hideTopLinks();
        return this;
    }

    @Override
    public SwingHtmlBuilder appendHtml5HeadWithOwnExtendedCssUtf8(String string, String string2) {
        super.appendHtml5HeadWithOwnExtendedCssUtf8(string, string2);
        return this;
    }

    @Override
    public SwingHtmlBuilder appendFoot() {
        super.appendFoot();
        return this;
    }

    @Override
    public SwingHtmlBuilder appendMultipleLines(String string) {
        super.appendMultipleLines(string);
        return this;
    }

    @Override
    public SwingHtmlBuilder appendOpeningUl() {
        super.appendOpeningUl();
        return this;
    }

    @Override
    public SwingHtmlBuilder appendClosingUl() {
        super.appendClosingUl();
        return this;
    }

    public SwingHtmlBuilder appendOpeningTagWithStyle(String string, String string2) {
        this.appendOpeningTagWithParameters(string, "style=\"" + string2 + "\"");
        return this;
    }

    public SwingHtmlBuilder appendOpeningDivWithStyle(String string) {
        this.appendOpeningTagWithStyle("div", string);
        return this;
    }

    public SwingHtmlBuilder appendLocalBackgroundColoredDiv(String string) {
        this.appendOpeningDivWithStyle(this.createBackgroundColorStylePart(string));
        return this;
    }

    @Override
    public SwingHtmlBuilder appendTopLinksToH2() {
        super.appendTopLinksToH2();
        return this;
    }

    @Override
    public SwingHtmlBuilder appendTopAnker() {
        super.appendTopAnker();
        return this;
    }

    @Override
    protected final SwingHtmlBuilder appendMetaUtf8() {
        this.appendLn("<meta http-equiv=\"content-Type\" content=\"text/html; charset=utf-8\">");
        return this;
    }
}

