/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.xml;

import de.duehl.basics.text.Text;
import de.duehl.basics.text.xml.NamedXmlParameter;
import de.duehl.basics.text.xml.XmlAnalyser;
import java.util.List;

public class XmlParameterExtractor {
    private final List<String> xml;
    private final String tag;

    public XmlParameterExtractor(List<String> list, String string) {
        this.xml = list;
        this.tag = string;
    }

    public List<NamedXmlParameter> extractParameters() {
        String string = this.xml.get(0);
        List<NamedXmlParameter> list = XmlAnalyser.getParametersFromOpeningTag(string, this.tag);
        return list;
    }

    public List<NamedXmlParameter> extractParametersAndCheckNumberOfParameters(int n) {
        List<NamedXmlParameter> list = this.extractParameters();
        if (list.size() != n) {
            throw new RuntimeException("Es wurde nicht wie gew\u00fcnscht " + n + " Parameter im \u00f6ffnenden Tag '" + this.tag + "' gefunden, sondern " + list.size() + ". Die zu anlysierenden Zeilen sind:\n\t" + Text.join("\n\t", this.xml));
        }
        return list;
    }

    public NamedXmlParameter extractSpecialParameter(String string) {
        List<NamedXmlParameter> list = this.extractParameters();
        return this.findTheWantedParameter(string, list);
    }

    public NamedXmlParameter extractSpecialParameterAndCheckNumberOfParametersIsOne(String string) {
        List<NamedXmlParameter> list = this.extractParametersAndCheckNumberOfParameters(1);
        return this.findTheWantedParameter(string, list);
    }

    private NamedXmlParameter findTheWantedParameter(String string, List<NamedXmlParameter> list) {
        for (NamedXmlParameter namedXmlParameter : list) {
            String string2 = namedXmlParameter.getName();
            if (!string2.equals(string)) continue;
            return namedXmlParameter;
        }
        throw new RuntimeException("Es wurde kein Parameter mit dem Namen '" + string + "' im \u00f6ffnenden Tag '" + this.tag + "' gefunden. Die zu anlysierenden Zeilen sind:\n\t" + Text.join("\n\t", this.xml));
    }
}

