/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.html.download.data;

import de.duehl.basics.text.Text;
import de.duehl.html.download.data.DownloadInfo;
import java.util.ArrayList;
import java.util.List;

public class DownloadInfoWithRedirects {
    private final String url;
    private final List<DownloadInfo> infosOfEachHop;
    private boolean tooMuchRedirects;
    private boolean redirectCycleDetected;
    private boolean redirectToNavigationshilfeTOnline;
    private boolean downloadCanceled;
    private boolean excpetionOccured;
    private Exception excpetion;

    public DownloadInfoWithRedirects(String string) {
        this.url = string;
        this.infosOfEachHop = new ArrayList<DownloadInfo>();
        this.tooMuchRedirects = false;
        this.redirectCycleDetected = false;
        this.redirectToNavigationshilfeTOnline = false;
        this.downloadCanceled = false;
        this.excpetionOccured = false;
        this.excpetion = new Exception("Keine Ausnahme aufgetreten! DownloadInfoWithRedirects");
    }

    public boolean isHopKnown(DownloadInfo downloadInfo) {
        String string = downloadInfo.getUrl();
        for (DownloadInfo downloadInfo2 : this.infosOfEachHop) {
            String string2 = downloadInfo2.getUrl();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public void addHop(DownloadInfo downloadInfo) {
        this.infosOfEachHop.add(downloadInfo);
    }

    public void tooMuchRedirects() {
        this.tooMuchRedirects = true;
    }

    public void redirectCycleDetected() {
        this.redirectCycleDetected = true;
    }

    public void redirectToNavigationshilfeTOnline() {
        this.redirectToNavigationshilfeTOnline = true;
    }

    public void downloadCanceled() {
        this.downloadCanceled = true;
    }

    public void exceptionOccured(Exception exception) {
        this.excpetionOccured = true;
        this.excpetion = exception;
    }

    public String getUrl() {
        return this.url;
    }

    public List<DownloadInfo> getInfosOfEachHop() {
        return this.infosOfEachHop;
    }

    public boolean hasTooMuchRedirects() {
        return this.tooMuchRedirects;
    }

    public boolean isRedirectCycleDetected() {
        return this.redirectCycleDetected;
    }

    public boolean isRedirectToNavigationshilfeTOnline() {
        return this.redirectToNavigationshilfeTOnline;
    }

    public boolean isDownloadCanceled() {
        return this.downloadCanceled;
    }

    public boolean isExcpetionOccured() {
        return this.excpetionOccured;
    }

    public Exception getExcpetion() {
        return this.excpetion;
    }

    public String getTargetUrl() {
        int n = this.infosOfEachHop.size();
        if (n < 1) {
            return "";
        }
        DownloadInfo downloadInfo = this.infosOfEachHop.get(n - 1);
        return downloadInfo.getReturnedUrl();
    }

    public boolean isDownloadSuccessfull() {
        int n = this.infosOfEachHop.size();
        if (this.redirectCycleDetected || this.tooMuchRedirects || this.redirectToNavigationshilfeTOnline || this.downloadCanceled || this.excpetionOccured || n < 1) {
            return false;
        }
        DownloadInfo downloadInfo = this.infosOfEachHop.get(n - 1);
        return downloadInfo.isDownloadSuccessfull();
    }

    public String getTargetContent() {
        int n = this.infosOfEachHop.size();
        if (n < 1) {
            return "";
        }
        DownloadInfo downloadInfo = this.infosOfEachHop.get(n - 1);
        return downloadInfo.getContent();
    }

    public String toString() {
        return "DownloadInfoWithRedirects [url=" + this.url + ", infosOfEachHop=" + this.infosOfEachHop + ", tooMuchRedirects=" + this.tooMuchRedirects + ", redirectCycleDetected=" + this.redirectCycleDetected + ", redirectToNavigationshilfeTOnline=" + this.redirectToNavigationshilfeTOnline + ", downloadCanceled=" + this.downloadCanceled + ", excpetionOccured=" + this.excpetionOccured + ", excpetion=" + this.excpetion + "]";
    }

    public String toStringWithoutContent() {
        return "DownloadInfoWithRedirects [url=" + this.url + ", infosOfEachHop=" + this.infosOfEachHoptoStringWithoutContent() + ", tooMuchRedirects=" + this.tooMuchRedirects + ", redirectCycleDetected=" + this.redirectCycleDetected + ", redirectToNavigationshilfeTOnline=" + this.redirectToNavigationshilfeTOnline + ", downloadCanceled=" + this.downloadCanceled + ", excpetionOccured=" + this.excpetionOccured + ", excpetion=" + this.excpetion + "]";
    }

    private String infosOfEachHoptoStringWithoutContent() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DownloadInfo downloadInfo : this.infosOfEachHop) {
            arrayList.add(downloadInfo.toStringWithoutContent());
        }
        return "[ " + Text.join(", ", arrayList) + " ]";
    }
}

