/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.html.download.logic;

import de.duehl.basics.logging.Logger;
import de.duehl.html.download.data.DownloadParameters;
import de.duehl.html.download.data.RedirectHandling;
import de.duehl.html.download.proxy.Proxy;
import de.duehl.html.download.proxy.RotatingProxies;
import org.apache.http.HttpHost;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;

public class HttpClientCreator {
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0";
    private final DownloadParameters parameters;

    public HttpClientCreator(DownloadParameters downloadParameters) {
        this.parameters = downloadParameters;
    }

    public CloseableHttpClient createClosableHttpClient() {
        this.log("Start");
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        this.addRedirectHandling(httpClientBuilder);
        this.addProxyUsing(httpClientBuilder);
        httpClientBuilder.setUserAgent(USER_AGENT);
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        this.log("httpClient created");
        return closeableHttpClient;
    }

    private void addRedirectHandling(HttpClientBuilder httpClientBuilder) {
        RedirectHandling redirectHandling = this.parameters.getRedirectHandling();
        switch (redirectHandling) {
            case STANDARD: {
                break;
            }
            case LAX: {
                httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
                break;
            }
            case NONE: {
                httpClientBuilder.disableRedirectHandling();
                break;
            }
            default: {
                throw new RuntimeException("Unknown RedirectHandling " + redirectHandling);
            }
        }
    }

    private void addProxyUsing(HttpClientBuilder httpClientBuilder) {
        if (this.parameters.useProxy()) {
            RotatingProxies rotatingProxies;
            this.log("using proxy");
            Proxy proxy = this.parameters.getProxy();
            if (this.parameters.useRotatingProxies()) {
                this.log("using rotating proxy");
                rotatingProxies = this.parameters.getRotatingProxies();
                proxy = rotatingProxies.getProxy();
            }
            this.log("use proxy " + proxy);
            rotatingProxies = new HttpHost(proxy.getAddress(), proxy.getPort());
            DefaultProxyRoutePlanner defaultProxyRoutePlanner = new DefaultProxyRoutePlanner((HttpHost)rotatingProxies);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)defaultProxyRoutePlanner);
        }
    }

    private void log(String string) {
        if (this.parameters.weHaveALogger()) {
            Logger logger = this.parameters.getLogger();
            logger.log(string, 1);
        }
    }
}

