/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.components.selections.FontSizeChangable;
import de.duehl.swing.ui.dragndrop.EditorUiElementManager;
import de.duehl.swing.ui.text.autocompletion.AutoCompletionTextComponentExtender;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class StringSelection
implements FontSizeChangable {
    static final int UNDIFINED_STANDARD_FONT_SIZE = -1;
    static final int LEFT_TITLE_DISTANCE = 5;
    private final JLabel titleLabel;
    protected JPanel mainPanel;
    private final JTextField textField;
    private int standardFontSize;
    private int standardLabelFontSize;

    public StringSelection(String string) {
        this.titleLabel = new JLabel(string);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.textField = new JTextField();
        GuiTools.setEditFieldColors(this.textField);
        this.mainPanel = this.createPanel();
        this.standardFontSize = -1;
        this.standardLabelFontSize = -1;
    }

    protected JPanel createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.titleLabel, "North");
        jPanel.add((Component)this.textField, "Center");
        return jPanel;
    }

    public String getText() {
        String string = this.textField.getText();
        return string;
    }

    public String getTrimmedText() {
        String string = this.getText();
        string = string.trim();
        return string;
    }

    public void setText(String string) {
        this.textField.setText(string);
    }

    public void setText(int n) {
        this.setText(Integer.toString(n));
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public void colorize(Colorizer colorizer) {
        colorizer.setColors(this.mainPanel);
        colorizer.setColors(this.titleLabel);
        colorizer.setColors(this.textField);
        colorizer.setEditFieldColors(this.textField);
    }

    public void setTitleColor(Color color) {
        this.titleLabel.setForeground(color);
    }

    public void setTextColor(Color color) {
        this.textField.setForeground(color);
    }

    public void setTextFieldPreferredSize(Dimension dimension) {
        this.textField.setPreferredSize(dimension);
    }

    public void setTextFieldMinimumSize(Dimension dimension) {
        this.textField.setMinimumSize(dimension);
    }

    public void addTextFieldFocuslistener(FocusListener focusListener) {
        this.textField.addFocusListener(focusListener);
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
    }

    public void setFocusable(boolean bl) {
        this.textField.setFocusable(bl);
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void requestFocusLater() {
        SwingUtilities.invokeLater(() -> this.requestFocus());
    }

    public boolean hasFocus() {
        return this.textField.hasFocus();
    }

    public void makeHorizontal() {
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)this.titleLabel, "West");
        this.mainPanel.add((Component)this.textField, "Center");
    }

    public void addKeyListener(KeyListener keyListener) {
        this.textField.addKeyListener(keyListener);
    }

    public void addReturnListener(Runnable runnable) {
        GuiTools.addReturnListener(this.textField, runnable);
    }

    public void setToolTipText(String string) {
        this.titleLabel.setToolTipText(string);
        this.mainPanel.setToolTipText(string);
        this.textField.setToolTipText(string);
        this.textField.setToolTipText(string);
    }

    public void addTextFieldActionListener(ActionListener actionListener) {
        this.textField.addActionListener(actionListener);
    }

    public void setBackgroundColor(Color color) {
        this.textField.setBackground(color);
    }

    public void setForegroundColor(Color color) {
        this.textField.setForeground(color);
    }

    @Override
    public void biggerText(int n) {
        GuiTools.biggerFont(this.textField, n);
    }

    @Override
    public void storeAsStandardFontSize() {
        Font font = this.textField.getFont();
        this.standardFontSize = font.getSize();
    }

    @Override
    public void setToStandardFontSize() {
        if (this.standardFontSize != -1) {
            this.setFontSize(this.standardFontSize);
        }
    }

    @Override
    public int getFontSize() {
        Font font = this.textField.getFont();
        return font.getSize();
    }

    @Override
    public void setFontSize(int n) {
        GuiTools.setFontSize(this.textField, n);
    }

    @Override
    public void biggerLabelText(int n) {
        GuiTools.biggerFont(this.titleLabel, n);
    }

    @Override
    public void storeAsStandardLabelFontSize() {
        Font font = this.titleLabel.getFont();
        this.standardLabelFontSize = font.getSize();
    }

    @Override
    public void setToStandardLabelFontSize() {
        if (this.standardLabelFontSize != -1) {
            this.setLabelFontSize(this.standardLabelFontSize);
        }
    }

    @Override
    public int getLabelFontSize() {
        Font font = this.titleLabel.getFont();
        return font.getSize();
    }

    @Override
    public void setLabelFontSize(int n) {
        GuiTools.setFontSize(this.titleLabel, n);
    }

    public void setCaretColor(Color color) {
        this.textField.setCaretColor(color);
    }

    public void setRedCaretColor() {
        this.textField.setCaretColor(Color.RED);
    }

    public void setCaretToLeft() {
        this.textField.setCaretPosition(0);
    }

    public void setMonospacedFont() {
        GuiTools.setMonospacedFont(this.textField);
    }

    public void setMonospacedFont(int n) {
        GuiTools.setMonospacedFont(this.textField, n);
    }

    public void addChangeListenerAndDragNDropCorrectorToTextField(EditorUiElementManager editorUiElementManager) {
        editorUiElementManager.addChangeListenerAndDragNDropCorrectorToTextField(this.textField);
    }

    public void setDragEnabled(boolean bl) {
        this.textField.setDragEnabled(bl);
    }

    public void switchLabelToBold() {
        GuiTools.boldFont(this.titleLabel);
    }

    public void switchTextToBold() {
        GuiTools.boldFont(this.textField);
    }

    public void switchLabelToNormal() {
        GuiTools.normalFont(this.titleLabel);
    }

    public void switchTextToNormal() {
        GuiTools.normalFont(this.textField);
    }

    public void rightTextfieldAlignment() {
        this.textField.setHorizontalAlignment(4);
    }

    public int getNumberOfDisplayableCharakters() {
        this.textField.setHorizontalAlignment(4);
        int n = this.textField.getWidth();
        Font font = this.textField.getFont();
        String string = font.getFamily();
        if ("Monospaced".equals(string)) {
            int n2 = font.getSize();
            int n3 = (int)(1.58 * (double)n / (double)n2);
            return n3;
        }
        return -1;
    }

    public void addAutoCompletion(List<String> list) {
        AutoCompletionTextComponentExtender autoCompletionTextComponentExtender = new AutoCompletionTextComponentExtender(this.textField, list);
        autoCompletionTextComponentExtender.changeActivationKeyToSpace();
        autoCompletionTextComponentExtender.doNotInsertSpaceBehindCompletion();
        autoCompletionTextComponentExtender.setMinimalLengthForAutoCompletionStart(1);
        autoCompletionTextComponentExtender.extendAutoCompletion();
    }

    public void setEnabled(boolean bl) {
        this.textField.setEnabled(bl);
    }

    public void setBorder(Border border) {
        this.mainPanel.setBorder(border);
    }

    public void setHorizontalAlignment(int n) {
        this.textField.setHorizontalAlignment(n);
    }

    public void addTextFieldDocumentListener(DocumentListener documentListener) {
        Document document = this.textField.getDocument();
        document.addDocumentListener(documentListener);
    }

    public void reactOnDoubleClick(Runnable runnable) {
        this.textField.addMouseListener(GuiTools.createDoubleClickMouseAdapter(runnable));
    }

    public void dispatchMouseScrollEvent() {
        GuiTools.dispatchMouseScrollEvent(this.textField);
        GuiTools.dispatchMouseScrollEvent(this.mainPanel);
    }

    public void repaintEditField() {
        this.textField.repaint();
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }
}

