/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections.datetime;

import de.duehl.swing.data.MinuteHour;
import de.duehl.swing.ui.components.selections.datetime.spinnermodels.CyclingSpinnerListModel;
import de.duehl.swing.ui.components.selections.datetime.spinnermodels.HourSpinnerModel;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;

class TimeSelectionBase {
    private final CyclingSpinnerListModel<String> hourSpinnerModel = new HourSpinnerModel();
    private final CyclingSpinnerListModel<String> minuteSpinnerModel;
    private final JPanel panel;
    private final JSpinner hourSpinner;
    private final JSpinner minuteSpinner;

    public TimeSelectionBase(CyclingSpinnerListModel<String> cyclingSpinnerListModel) {
        this.minuteSpinnerModel = cyclingSpinnerListModel;
        this.hourSpinner = new JSpinner(this.hourSpinnerModel);
        JSpinner.ListEditor listEditor = new JSpinner.ListEditor(this.hourSpinner);
        this.hourSpinner.setEditor(listEditor);
        this.minuteSpinner = new JSpinner(cyclingSpinnerListModel);
        JSpinner.ListEditor listEditor2 = new JSpinner.ListEditor(this.minuteSpinner);
        this.minuteSpinner.setEditor(listEditor2);
        this.panel = this.createPanel();
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.hourSpinner);
        jPanel.add(new JLabel(":"));
        jPanel.add(this.minuteSpinner);
        return jPanel;
    }

    public final JPanel getPanel() {
        return this.panel;
    }

    public final MinuteHour getTime() {
        String string = this.hourSpinnerModel.getSelectedValue();
        String string2 = this.minuteSpinnerModel.getSelectedValue();
        return new MinuteHour(string + ":" + string2);
    }

    public final void setTime(MinuteHour minuteHour) {
        this.hourSpinner.setValue(minuteHour.getHour());
        this.minuteSpinner.setValue(minuteHour.getMinute());
    }
}

