/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JPanel;

public class PanelDialogYesNo
extends ModalDialogBase {
    private final JPanel panel;
    private boolean answeredYes;
    private final JButton yesButton;
    private final JButton noButton;

    public PanelDialogYesNo(JPanel jPanel, Point point, Image image, String string) {
        this(jPanel, null, point, image, string);
    }

    public PanelDialogYesNo(JPanel jPanel, Colorizer colorizer, Point point, Image image, String string) {
        super(point, image, string, colorizer);
        this.addClosingWindowListener(() -> this.no());
        this.panel = jPanel;
        this.answeredYes = false;
        this.yesButton = this.createYesButton();
        this.noButton = this.createNoButton();
        this.fillDialog();
    }

    private JButton createYesButton() {
        JButton jButton = new JButton("Ja");
        this.setColors(jButton);
        GuiTools.boldFont(jButton);
        jButton.requestFocusInWindow();
        jButton.addActionListener(actionEvent -> this.yes());
        return jButton;
    }

    private JButton createNoButton() {
        JButton jButton = new JButton("Nein");
        this.setColors(jButton);
        jButton.addActionListener(actionEvent -> this.no());
        return jButton;
    }

    @Override
    protected void populateDialog() {
        this.add(this.panel, "Center");
        this.add(this.createButtonPart(), "South");
        this.addEscapeBehaviour();
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createYesNoButtons(), "East");
        return jPanel;
    }

    private Component createYesNoButtons() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.yesButton, "West");
        jPanel.add((Component)this.noButton, "East");
        return jPanel;
    }

    private void yes() {
        this.answeredYes = true;
        this.closeDialog();
    }

    private void no() {
        this.answeredYes = false;
        this.closeDialog();
    }

    public boolean isAnsweredYes() {
        return this.answeredYes;
    }

    public void setYesTextTo(String string) {
        this.yesButton.setText(string);
    }

    public void setNoTextTo(String string) {
        this.noButton.setText(string);
    }
}

