/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.navigator;

import java.util.List;

public class NavigatedData<Data> {
    private final List<Data> uiDatasets;
    private int actualShownIndex;

    public NavigatedData(List<Data> list) {
        this.uiDatasets = list;
        this.actualShownIndex = 0;
    }

    public final int size() {
        return this.uiDatasets.size();
    }

    public final Data getActualData() {
        this.throwExceptionIfEmpty();
        return this.uiDatasets.get(this.actualShownIndex);
    }

    protected final int getActualShownIndex() {
        this.throwExceptionIfEmpty();
        return this.actualShownIndex;
    }

    private void throwExceptionIfEmpty() {
        if (this.isEmpty()) {
            throw new RuntimeException("Illegale Abfrage auf einer leeren Menge!");
        }
    }

    public final int getDocumentNumber() {
        return this.actualShownIndex + 1;
    }

    public final void setDocumentNumber(int n) {
        int n2 = n - 1;
        if (n2 >= this.firstIndex() && n2 <= this.lastIndex()) {
            this.actualShownIndex = n2;
        }
    }

    public final void first() {
        this.actualShownIndex = this.firstIndex();
    }

    public final void next() {
        if (this.actualShownIndex < this.lastIndex()) {
            ++this.actualShownIndex;
        }
    }

    public final void previous() {
        if (this.actualShownIndex > this.firstIndex()) {
            --this.actualShownIndex;
        }
    }

    public final void last() {
        this.actualShownIndex = this.lastIndex();
    }

    public final boolean isFirst() {
        return this.actualShownIndex == this.firstIndex();
    }

    public final boolean isLast() {
        return this.actualShownIndex == this.lastIndex();
    }

    private int firstIndex() {
        return 0;
    }

    private int lastIndex() {
        return this.size() - 1;
    }

    public boolean isEmpty() {
        return this.uiDatasets.isEmpty();
    }

    public int indexOf(Data Data) {
        return this.uiDatasets.indexOf(Data);
    }

    public Data getPrevious() {
        this.throwExceptionIfEmpty();
        if (this.actualShownIndex > this.firstIndex()) {
            return this.uiDatasets.get(this.actualShownIndex - 1);
        }
        throw new RuntimeException("Zum ersten Datensatz gibt es keinen Vorg\u00e4nger.");
    }

    public Data getNext() {
        this.throwExceptionIfEmpty();
        if (this.actualShownIndex < this.lastIndex()) {
            return this.uiDatasets.get(this.actualShownIndex + 1);
        }
        throw new RuntimeException("Zum letzten Datensatz gibt es keinen Nachfolger.");
    }
}

