/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.navigator;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.painted.FirstButton;
import de.duehl.swing.ui.buttons.painted.LastButton;
import de.duehl.swing.ui.buttons.painted.NextButton;
import de.duehl.swing.ui.buttons.painted.PreviousButton;
import de.duehl.swing.ui.layout.ExtendedFlowLayout;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class NavigatorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final Dimension DEFAULT_BUTTON_SIZE = new Dimension(30, 40);
    protected static final int HORIZONTAL_GAP = 5;
    protected static final int VERTICAL_GAP = 0;
    protected final Dimension buttonSize;
    private final JButton firstButton;
    private final JButton previousButton;
    private final JButton nextButton;
    private final JButton lastButton;

    public NavigatorPanel() {
        this(DEFAULT_BUTTON_SIZE);
    }

    public NavigatorPanel(Dimension dimension) {
        this.buttonSize = dimension;
        this.setLayoutAndPreferredSize();
        this.firstButton = new FirstButton();
        this.previousButton = new PreviousButton();
        this.nextButton = new NextButton();
        this.lastButton = new LastButton();
    }

    private void setLayoutAndPreferredSize() {
        this.setLayout(new ExtendedFlowLayout(1, 5, 0));
        this.setPreferredSize(this.calculatePreferredSize());
    }

    private Dimension calculatePreferredSize() {
        int n = this.calculatePreferredWidth();
        int n2 = this.calculatePreferredHeight();
        return new Dimension(n, n2);
    }

    protected int calculatePreferredWidth() {
        int n = 4;
        int n2 = this.buttonSize.width;
        int n3 = n * n2 + (n + 1) * 5;
        return n3 += n2;
    }

    protected int calculatePreferredHeight() {
        int n = 1;
        int n2 = this.buttonSize.height;
        int n3 = n * n2 + (n + 1) * 0;
        return n3;
    }

    public final void fillNavigator() {
        this.addElements();
        this.initElelents();
    }

    protected void addElements() {
        this.addLeftNavigationElements();
        this.addRightNavigationElements();
    }

    protected final void addLeftNavigationElements() {
        this.add(this.firstButton);
        this.add(this.previousButton);
    }

    protected final void addRightNavigationElements() {
        this.add(this.nextButton);
        this.add(this.lastButton);
    }

    protected void initElelents() {
        this.setButtonDimensions();
        this.setButtonToolTips();
    }

    private void setButtonDimensions() {
        this.firstButton.setPreferredSize(this.buttonSize);
        this.previousButton.setPreferredSize(this.buttonSize);
        this.nextButton.setPreferredSize(this.buttonSize);
        this.lastButton.setPreferredSize(this.buttonSize);
    }

    private void setButtonToolTips() {
        this.firstButton.setToolTipText("Zeige ersten Datensatz an.");
        this.previousButton.setToolTipText("Zeige vorigen Datensatz an.");
        this.nextButton.setToolTipText("Zeige n\u00e4chsten Datensatz an.");
        this.lastButton.setToolTipText("Zeige letzten Datensatz an.");
    }

    public void addFirstActionListener(ActionListener actionListener) {
        this.firstButton.addActionListener(actionListener);
    }

    public void addPreviousActionListener(ActionListener actionListener) {
        this.previousButton.addActionListener(actionListener);
    }

    public void addNextActionListener(ActionListener actionListener) {
        this.nextButton.addActionListener(actionListener);
    }

    public void addLastActionListener(ActionListener actionListener) {
        this.lastButton.addActionListener(actionListener);
    }

    public void setFirstToolTip(String string) {
        this.firstButton.setToolTipText(string);
    }

    public void setPreviousToolTip(String string) {
        this.previousButton.setToolTipText(string);
    }

    public void setNextToolTip(String string) {
        this.nextButton.setToolTipText(string);
    }

    public void setLastToolTip(String string) {
        this.lastButton.setToolTipText(string);
    }

    public JPanel centerHorizontal() {
        return GuiTools.centerHorizontal(this);
    }

    public JPanel centerVertical() {
        return GuiTools.centerVertical(this);
    }

    public JPanel center() {
        return GuiTools.center(this);
    }

    public void doClickOnFirstButton() {
        this.firstButton.doClick();
    }

    public void doClickOnPreviousButton() {
        this.previousButton.doClick();
    }

    public void doClickOnNextButton() {
        this.nextButton.doClick();
    }

    public void doClickOnLastButton() {
        this.lastButton.doClick();
    }
}

