/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.search;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.search.SearchReaktor;
import de.duehl.swing.ui.elements.textfield.EnterTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SearchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final SearchReaktor searchReaktor;
    private final EnterTextField searchTextField;

    public SearchPanel(SearchReaktor searchReaktor) {
        this.setLayout(new BorderLayout());
        this.searchReaktor = searchReaktor;
        this.searchTextField = new EnterTextField(string -> this.search(string));
        GuiTools.biggerFont(this.searchTextField, 2);
        this.add((Component)this.searchTextField, "Center");
        this.add(this.createSearchButtons(), "East");
    }

    private Component createSearchButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSearchButton(), "North");
        jPanel.add(this.createSearchAgainButton(), "South");
        return jPanel;
    }

    private Component createSearchButton() {
        JButton jButton = this.createButton("Suchen");
        jButton.addActionListener(actionEvent -> this.searchButtonPressed());
        return jButton;
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        jButton.setOpaque(true);
        jButton.setBackground(new Color(230, 230, 255));
        GuiTools.smalerFont(jButton, 2);
        return jButton;
    }

    private void searchButtonPressed() {
        this.search(this.getTrimmedSearchText());
    }

    private String getTrimmedSearchText() {
        return this.searchTextField.getText().trim();
    }

    private Component createSearchAgainButton() {
        JButton jButton = this.createButton("Weitersuchen");
        jButton.addActionListener(actionEvent -> this.searchAgainButtonPressed());
        return jButton;
    }

    private void searchAgainButtonPressed() {
        this.searchAgain();
    }

    private void search(String string) {
        this.searchReaktor.search(string);
    }

    private void searchAgain() {
        this.searchReaktor.searchAgain();
    }
}

