/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.filter.dialog;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FineFileWriter;
import de.duehl.swing.ui.buttons.painted.GoBackButton;
import de.duehl.swing.ui.buttons.painted.MinusButton;
import de.duehl.swing.ui.buttons.painted.PlusButton;
import de.duehl.swing.ui.filter.dialog.FilterCombinationLineHandler;
import de.duehl.swing.ui.filter.dialog.FilterCombinationLineType;
import de.duehl.swing.ui.filter.exceptions.FilterException;
import de.duehl.swing.ui.filter.project.gateway.FilterGateway;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FilterCombinationLine<Data, Type> {
    private static final Insets BUTTON_INSETS = new Insets(0, 3, 0, 3);
    static final String BITTE_WAEHLEN = "- bitte w\u00e4hlen -";
    private final JPanel combinationPanel;
    private int lineNumber;
    private final FilterGateway<Data, Type> gateway;
    private final FilterCombinationLineHandler<Data, Type> lineHandler;
    private FilterCombinationLineType type;
    private final JPanel linePanel;
    private JComboBox<String> methodComboBox;
    private JTextField parameterField;
    private static final String CHOICE_METHOD = "Methode";
    private static final String CHOICE_NEGATED_METHOD = "negierte Methode";
    private static final String CHOICE_PARAMISED_METHOD = "parametrisierte Methode";
    private static final String CHOICE_NEGATED_PARAMISED_METHOD = "negierte parametrisierte Methode";
    private static final String CHOICE_OPENING_BRACE = "Klammer auf";
    private static final String CHOICE_NEGATED_OPENING_BRACE = "negierte Klammer auf";
    private static final String CHOICE_CLOSING_BRACE = "Klammer zu";
    private static final String CHOICE_SCHNITTMENGE = "Schnittmenge (und)";
    private static final String CHOICE_VEREINIGUNG = "Vereinigung (oder)";

    public FilterCombinationLine(JPanel jPanel, int n, FilterGateway<Data, Type> filterGateway, FilterCombinationLineHandler<Data, Type> filterCombinationLineHandler) {
        this.combinationPanel = jPanel;
        this.lineNumber = n;
        this.gateway = filterGateway;
        this.lineHandler = filterCombinationLineHandler;
        this.linePanel = new JPanel();
        this.initLinePanel();
        this.createStartLine();
    }

    public FilterCombinationLine(JPanel jPanel, int n, FilterGateway<Data, Type> filterGateway, FilterCombinationLineHandler<Data, Type> filterCombinationLineHandler, String string) {
        this(jPanel, n, filterGateway, filterCombinationLineHandler);
        String[] stringArray = string.split("\\|");
        boolean bl = true;
        if (2 > stringArray.length) {
            bl = false;
        } else if (n != Integer.parseInt(stringArray[0])) {
            bl = false;
        } else if (2 == stringArray.length) {
            switch (stringArray[1]) {
                case "START": {
                    break;
                }
                case "INTERSECTION": {
                    this.createIntersection();
                    break;
                }
                case "UNION": {
                    this.createUnion();
                    break;
                }
                case "(": {
                    this.createOpeningBrace();
                    break;
                }
                case "NOT(": {
                    this.createNegatedOpeningBrace();
                    break;
                }
                case ")": {
                    this.createClosingBrace();
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        } else if (3 == stringArray.length) {
            if ("METHOD".equals(stringArray[1])) {
                this.createMethodLine();
            } else if ("NOT METHOD".equals(stringArray[1])) {
                this.createNegatedMethodLine();
            } else {
                bl = false;
            }
            if (bl) {
                this.methodComboBox.setSelectedItem(stringArray[2]);
            }
        } else if (4 == stringArray.length) {
            if ("PARAMISED METHOD".equals(stringArray[1])) {
                this.createParamisedMethodLine();
            } else if ("NOT PARAMISED METHOD".equals(stringArray[1])) {
                this.createNegatedParamisedMethodLine();
            } else {
                bl = false;
            }
            if (bl) {
                this.methodComboBox.setSelectedItem(stringArray[2]);
                this.parameterField.setText(stringArray[3]);
            }
        }
        if (!bl) {
            throw new FilterException("Kein Erfolg beim Vestehen der Filterzeile:\n\tline = " + string);
        }
    }

    private void initLinePanel() {
        this.linePanel.setLayout(new BorderLayout(5, 0));
        this.combinationPanel.add(this.linePanel);
    }

    private void createStartLine() {
        this.type = FilterCombinationLineType.START;
        this.linePanel.removeAll();
        this.linePanel.add(this.createAndAndRemoveButtonPart(), "West");
        this.linePanel.add(this.createChoiceComboBox(), "East");
        this.methodComboBox = null;
        this.parameterField = null;
    }

    private Component createAndAndRemoveButtonPart() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.createAddButton());
        jPanel.add(this.createDeleteButton());
        return jPanel;
    }

    private Component createAndRemoveAndRevertButtonPart() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.createBackToStartButton());
        jPanel.add(this.createAddButton());
        jPanel.add(this.createDeleteButton());
        return jPanel;
    }

    private Component createBackToStartButton() {
        GoBackButton goBackButton = new GoBackButton();
        goBackButton.setFocusable(false);
        goBackButton.setMargin(BUTTON_INSETS);
        goBackButton.addActionListener(actionEvent -> this.createStartLine());
        return goBackButton;
    }

    private Component createAddButton() {
        PlusButton plusButton = new PlusButton();
        plusButton.setFocusable(false);
        plusButton.setMargin(BUTTON_INSETS);
        plusButton.addActionListener(actionEvent -> this.lineHandler.addLine(this));
        return plusButton;
    }

    private Component createDeleteButton() {
        MinusButton minusButton = new MinusButton();
        minusButton.setFocusable(false);
        minusButton.setMargin(BUTTON_INSETS);
        minusButton.addActionListener(actionEvent -> this.lineHandler.removeLine(this));
        return minusButton;
    }

    private Component createChoiceComboBox() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(BITTE_WAEHLEN);
        if (this.gateway.hasMethods()) {
            arrayList.add(CHOICE_METHOD);
            arrayList.add(CHOICE_NEGATED_METHOD);
        }
        if (this.gateway.hasParamisedMethods()) {
            arrayList.add(CHOICE_PARAMISED_METHOD);
            arrayList.add(CHOICE_NEGATED_PARAMISED_METHOD);
        }
        arrayList.add(CHOICE_OPENING_BRACE);
        arrayList.add(CHOICE_NEGATED_OPENING_BRACE);
        arrayList.add(CHOICE_CLOSING_BRACE);
        arrayList.add(CHOICE_SCHNITTMENGE);
        arrayList.add(CHOICE_VEREINIGUNG);
        String[] stringArray = CollectionsHelper.stringListToArray(arrayList);
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (String string : stringArray) {
            jComboBox.addItem(string);
        }
        jComboBox.addActionListener(actionEvent -> this.replaceStartLineByWantedLine((String)jComboBox.getSelectedItem()));
        return jComboBox;
    }

    private void replaceStartLineByWantedLine(String string) {
        switch (string) {
            case "Methode": {
                this.createMethodLine();
                break;
            }
            case "negierte Methode": {
                this.createNegatedMethodLine();
                break;
            }
            case "parametrisierte Methode": {
                this.createParamisedMethodLine();
                break;
            }
            case "negierte parametrisierte Methode": {
                this.createNegatedParamisedMethodLine();
                break;
            }
            case "Klammer auf": {
                this.createOpeningBrace();
                break;
            }
            case "negierte Klammer auf": {
                this.createNegatedOpeningBrace();
                break;
            }
            case "Klammer zu": {
                this.createClosingBrace();
                break;
            }
            case "Schnittmenge (und)": {
                this.createIntersection();
                break;
            }
            case "Vereinigung (oder)": {
                this.createUnion();
            }
        }
    }

    private void createMethodLine() {
        this.type = FilterCombinationLineType.METHOD;
        this.linePanel.removeAll();
        this.linePanel.add(this.createAndRemoveAndRevertButtonPart(), "West");
        this.linePanel.add((Component)new JLabel(" Methode "), "Center");
        this.linePanel.add(this.createMethodComboBox(), "East");
        this.validate();
    }

    private Component createMethodComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(BITTE_WAEHLEN);
        for (String string : this.gateway.getMethods()) {
            jComboBox.addItem(string);
        }
        this.methodComboBox = jComboBox;
        return jComboBox;
    }

    private void createNegatedMethodLine() {
        this.type = FilterCombinationLineType.NEGATED_METHOD;
        this.linePanel.removeAll();
        this.linePanel.add(this.createAndRemoveAndRevertButtonPart(), "West");
        this.linePanel.add((Component)new JLabel(" nicht Methode "), "Center");
        this.linePanel.add(this.createMethodComboBox(), "East");
        this.validate();
    }

    private void createParamisedMethodLine() {
        this.type = FilterCombinationLineType.PARAMISED_METHOD;
        this.linePanel.removeAll();
        this.linePanel.add(this.createAndRemoveAndRevertButtonPart(), "West");
        this.linePanel.add((Component)new JLabel(" parametrisierte Methode "), "Center");
        this.linePanel.add(this.createParamizedMethodComboBoxAndParameterField(), "East");
        this.validate();
    }

    private Component createParamizedMethodComboBoxAndParameterField() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.createParamizedMethodComboBox());
        jPanel.add(this.createParameterField());
        return jPanel;
    }

    private Component createParamizedMethodComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(BITTE_WAEHLEN);
        for (String string : this.gateway.getParamisedMethods()) {
            jComboBox.addItem(string);
        }
        this.methodComboBox = jComboBox;
        return jComboBox;
    }

    private JTextField createParameterField() {
        JTextField jTextField = new JTextField("", 6);
        jTextField.requestFocus();
        this.parameterField = jTextField;
        return jTextField;
    }

    private void createNegatedParamisedMethodLine() {
        this.type = FilterCombinationLineType.NEGATED_PARAMISED_METHOD;
        this.linePanel.removeAll();
        this.linePanel.add(this.createAndRemoveAndRevertButtonPart(), "West");
        this.linePanel.add((Component)new JLabel(" nicht parametrisierte Methode "), "Center");
        this.linePanel.add(this.createParamizedMethodComboBoxAndParameterField(), "East");
        this.validate();
    }

    private void createOpeningBrace() {
        this.type = FilterCombinationLineType.BRACE_OPEN;
        this.linePanel.removeAll();
        this.linePanel.add(this.createAndRemoveAndRevertButtonPart(), "West");
        this.linePanel.add((Component)new JLabel(" ("), "Center");
        this.validate();
    }

    private void createNegatedOpeningBrace() {
        this.type = FilterCombinationLineType.NEGATED_BRACE_OPEN;
        this.linePanel.removeAll();
        this.linePanel.add(this.createAndRemoveAndRevertButtonPart(), "West");
        this.linePanel.add((Component)new JLabel(" nicht ("), "Center");
        this.validate();
    }

    private void createClosingBrace() {
        this.type = FilterCombinationLineType.BRACE_CLOSE;
        this.linePanel.removeAll();
        this.linePanel.add(this.createAndRemoveAndRevertButtonPart(), "West");
        this.linePanel.add((Component)new JLabel(" )"), "Center");
        this.validate();
    }

    private void createIntersection() {
        this.type = FilterCombinationLineType.INTERSECTION;
        this.linePanel.removeAll();
        this.linePanel.add(this.createAndRemoveAndRevertButtonPart(), "West");
        this.linePanel.add((Component)new JLabel(" geschnitten mit (und)"), "Center");
        this.validate();
    }

    private void createUnion() {
        this.type = FilterCombinationLineType.UNION;
        this.linePanel.removeAll();
        this.linePanel.add(this.createAndRemoveAndRevertButtonPart(), "West");
        this.linePanel.add((Component)new JLabel(" vereinigt mit (oder)"), "Center");
        this.validate();
    }

    public void validate() {
        this.linePanel.validate();
        this.combinationPanel.validate();
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodComboBoxSelection() {
        if (null == this.methodComboBox) {
            throw new FilterException("methodComboBox ist null!");
        }
        return (String)this.methodComboBox.getSelectedItem();
    }

    public String getParameter() {
        if (null == this.parameterField) {
            throw new FilterException("parameterField ist null!");
        }
        return this.parameterField.getText();
    }

    public String getTypeAsString() {
        return this.type.toString();
    }

    public JPanel getLinePanel() {
        return this.linePanel;
    }

    public boolean isInStartPhase() {
        return this.type == FilterCombinationLineType.START;
    }

    public boolean isMethodLine() {
        return this.type == FilterCombinationLineType.METHOD;
    }

    public boolean isNegatedMethodLine() {
        return this.type == FilterCombinationLineType.NEGATED_METHOD;
    }

    public boolean isParamisedMethodLine() {
        return this.type == FilterCombinationLineType.PARAMISED_METHOD;
    }

    public boolean isParamisedNegatedMethodLine() {
        return this.type == FilterCombinationLineType.NEGATED_PARAMISED_METHOD;
    }

    public boolean isIntersectionLine() {
        return this.type == FilterCombinationLineType.INTERSECTION;
    }

    public boolean isUnionLine() {
        return this.type == FilterCombinationLineType.UNION;
    }

    public boolean isBraceOpenLine() {
        return this.type == FilterCombinationLineType.BRACE_OPEN;
    }

    public boolean isNegatedBraceOpenLine() {
        return this.type == FilterCombinationLineType.NEGATED_BRACE_OPEN;
    }

    public boolean isBraceCloseLine() {
        return this.type == FilterCombinationLineType.BRACE_CLOSE;
    }

    public void write(FineFileWriter fineFileWriter) {
        switch (this.type) {
            case START: {
                fineFileWriter.writeln(this.lineNumber + "|START");
                break;
            }
            case METHOD: {
                fineFileWriter.writeln(this.lineNumber + "|METHOD|" + this.methodComboBox.getSelectedItem());
                break;
            }
            case NEGATED_METHOD: {
                fineFileWriter.writeln(this.lineNumber + "|NOT METHOD|" + this.methodComboBox.getSelectedItem());
                break;
            }
            case PARAMISED_METHOD: {
                fineFileWriter.writeln(this.lineNumber + "|PARAMISED METHOD|" + this.methodComboBox.getSelectedItem() + "|" + this.parameterField.getText());
                break;
            }
            case NEGATED_PARAMISED_METHOD: {
                fineFileWriter.writeln(this.lineNumber + "|NOT PARAMISED METHOD|" + this.methodComboBox.getSelectedItem() + "|" + this.parameterField.getText());
                break;
            }
            case INTERSECTION: {
                fineFileWriter.writeln(this.lineNumber + "|INTERSECTION");
                break;
            }
            case UNION: {
                fineFileWriter.writeln(this.lineNumber + "|UNION");
                break;
            }
            case BRACE_OPEN: {
                fineFileWriter.writeln(this.lineNumber + "|(");
                break;
            }
            case NEGATED_BRACE_OPEN: {
                fineFileWriter.writeln(this.lineNumber + "|NOT(");
                break;
            }
            case BRACE_CLOSE: {
                fineFileWriter.writeln(this.lineNumber + "|)");
                break;
            }
            default: {
                fineFileWriter.writeln(this.lineNumber + "|UNKNOWN STUFF");
            }
        }
    }

    public String getMethodDescription() {
        String string = this.getMethodComboBoxSelection();
        if (string.equals(BITTE_WAEHLEN)) {
            throw new FilterException("Inhalt der methodComboBox ist noch '- bitte w\u00e4hlen -'!");
        }
        return string;
    }
}

