/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.io.lock.ui;

import de.duehl.basics.text.html.HtmlTool;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.io.lock.ui.NoLockGainedDialogAnswer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class NoLockGainedDialog
extends ModalDialogBase {
    private final String message;
    private NoLockGainedDialogAnswer answer;
    private final JButton retryWithoutRemovingLockButton;
    private final JButton removeLockAndRetryButton;
    private final JButton cancelButton;

    public NoLockGainedDialog(String string, String string2) {
        this(new Point(200, 100), null, string, string2);
    }

    public NoLockGainedDialog(Point point, Image image, String string, String string2) {
        super(point, image, string);
        this.addClosingWindowListener(() -> this.cancel());
        this.message = string2;
        this.answer = NoLockGainedDialogAnswer.CANCEL;
        this.retryWithoutRemovingLockButton = this.createRetryWithoutRemovingLockButton();
        this.removeLockAndRetryButton = this.createRemoveLockAndRetryButton();
        this.cancelButton = this.createCancelButton();
        this.fillDialog();
        SwingUtilities.invokeLater(() -> this.retryWithoutRemovingLockButton.requestFocusInWindow());
    }

    private JButton createRetryWithoutRemovingLockButton() {
        JButton jButton = new JButton("Erneut versuchen");
        GuiTools.boldFont(jButton);
        jButton.addActionListener(actionEvent -> this.retryWithoutRemovingLock());
        GuiTools.biggerFont(jButton, 2);
        return jButton;
    }

    private JButton createRemoveLockAndRetryButton() {
        JButton jButton = new JButton("Lock entfernen und wiederholen");
        jButton.addActionListener(actionEvent -> this.removeLockAndRetry());
        GuiTools.biggerFont(jButton, 2);
        return jButton;
    }

    private JButton createCancelButton() {
        JButton jButton = new JButton("Abbruch");
        jButton.addActionListener(actionEvent -> this.cancel());
        GuiTools.biggerFont(jButton, 2);
        return jButton;
    }

    @Override
    protected void populateDialog() {
        this.add(this.createMessagePart(), "Center");
        this.add(this.createButtonPart(), "South");
        this.addEscapeBehaviour();
    }

    protected JLabel createMessagePart() {
        JLabel jLabel = new JLabel(HtmlTool.htmlify(this.message));
        GuiTools.biggerFont(jLabel, 5);
        jLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        GuiTools.createTitle(jLabel);
        return jLabel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createButtons(), "East");
        jPanel.add((Component)this.cancelButton, "West");
        return jPanel;
    }

    private Component createButtons() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.retryWithoutRemovingLockButton, "East");
        jPanel.add((Component)this.removeLockAndRetryButton, "West");
        return jPanel;
    }

    private void retryWithoutRemovingLock() {
        this.answer = NoLockGainedDialogAnswer.RETRY_WITHOUT_REMOVING_LOCK;
        this.closeDialog();
    }

    private void removeLockAndRetry() {
        this.answer = NoLockGainedDialogAnswer.REMOVE_LOCK_AND_RETRY;
        this.closeDialog();
    }

    private void cancel() {
        this.answer = NoLockGainedDialogAnswer.CANCEL;
        this.closeDialog();
    }

    public NoLockGainedDialogAnswer getAnswer() {
        return this.answer;
    }
}

