/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.key;

import de.duehl.swing.ui.menu.collection.tools.MyMenuItemCollectionHelper;

public class KeyDefinition {
    public static final KeyDefinition NO_KEY_DEFINIED = new KeyDefinition(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final String NO_KEYBOARD_SHORTCUT_DEFFINED = "NO KEYBOARD SHORTCUT DEFFINED";
    private final int keyCode;
    private final int modifiers;

    public KeyDefinition(int n, int n2) {
        this.keyCode = n;
        this.modifiers = n2;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isDefined() {
        return !this.equals(NO_KEY_DEFINIED);
    }

    public String toReadableString() {
        if (this.isDefined()) {
            return MyMenuItemCollectionHelper.generateKeyboardCommandDescription(this);
        }
        return NO_KEYBOARD_SHORTCUT_DEFFINED;
    }

    public String toString() {
        String string = this.toReadableString();
        return "KeyDefinition [" + string + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.keyCode;
        n = 31 * n + this.modifiers;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyDefinition keyDefinition = (KeyDefinition)object;
        if (this.keyCode != keyDefinition.keyCode) {
            return false;
        }
        return this.modifiers == keyDefinition.modifiers;
    }
}

