/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.layout.card;

import de.duehl.swing.ui.layout.card.Card;
import de.duehl.swing.ui.layout.card.CardGui;
import de.duehl.swing.ui.layout.card.CardLogic;
import de.duehl.swing.ui.layout.card.CardSwitcher;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public abstract class Cards {
    private final List<Card> cards = new ArrayList<Card>();

    protected Cards() {
    }

    protected final void addCard(String string, CardGui cardGui, CardLogic cardLogic, String string2) {
        int n = this.cards.size() + 1;
        Card card = new Card(string, cardGui, cardLogic, n, string2);
        card.setCards(this);
        this.cards.add(card);
    }

    Card getFirstCard() {
        return this.cards.get(0);
    }

    Card getNext(Card card) {
        int n = this.cards.indexOf(card);
        int n2 = n + 1;
        if (n2 >= this.cards.size()) {
            throw new RuntimeException("Keine weitere Karte vorhanden.");
        }
        Card card2 = this.cards.get(n2);
        return card2;
    }

    void addAllCardsToPanel(JPanel jPanel, CardSwitcher cardSwitcher) {
        for (Card card : this.cards) {
            jPanel.add(card.createCardGui(cardSwitcher), card.getName());
        }
    }

    public void checkStepNumber(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Die Schrittnummer " + n + " ist zu klein, sie muss mindestens 1 betragen.");
        }
        if (n > this.cards.size()) {
            throw new IllegalArgumentException("Die Schrittnummer " + n + " ist zu gro\u00df, sie darf h\u00f6chstens " + this.cards.size() + " betragen.");
        }
    }

    public int getNumberOfSteps() {
        return this.cards.size();
    }

    public Card getCard(int n) {
        this.checkStepNumber(n);
        int n2 = n - 1;
        return this.cards.get(n2);
    }
}

