/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.io;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import java.util.ArrayList;

public class OwnListWriter {
    private final OwnList ownList;
    private final InternalDataRequester requester;
    private String filename;
    private boolean specialFilenameForWrongTestedVocables;

    public OwnListWriter(OwnList ownList, InternalDataRequester internalDataRequester) {
        this.ownList = ownList;
        this.requester = internalDataRequester;
        this.specialFilenameForWrongTestedVocables = false;
    }

    public void useSpecialFilenameForWrongTestedVocables(String string) {
        this.filename = string;
        this.specialFilenameForWrongTestedVocables = true;
    }

    public void write() {
        this.createFilename();
        this.writeOwnList();
    }

    private void createFilename() {
        if (!this.specialFilenameForWrongTestedVocables) {
            this.filename = this.ownList.determineFilename();
        }
    }

    private void writeOwnList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("own-list-category = " + this.ownList.getCategory());
        arrayList.add("own-list-sub-category = " + this.ownList.getSubCategory());
        for (Vocable vocable : this.ownList.getVocables()) {
            InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
            String string = internalAdditionalVocableData.getKey();
            arrayList.add(string);
        }
        FileHelper.writeLinesToFile(arrayList, this.filename, Charset.UTF_8);
    }
}

