/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.test;

import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import java.util.List;

public class UserAnswerCorrectnessChecker {
    private final Options options;
    private final String compareTranslationByUser;
    private final List<Vocable> matchingVocables;
    private boolean correct;
    private Vocable correctVocable;

    public UserAnswerCorrectnessChecker(Options options, String string, List<Vocable> list) {
        this.options = options;
        this.matchingVocables = list;
        this.compareTranslationByUser = VocabularyTools.createCompareTranslation(string);
        this.correct = false;
    }

    public void check() {
        TranslationDirection translationDirection = this.options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            this.checkJapaneseToGerman();
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            this.checkGermanToJapanese();
        } else {
            throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection);
        }
    }

    private void checkJapaneseToGerman() {
        this.correct = false;
        for (Vocable vocable : this.matchingVocables) {
            if (!vocable.getCompareTranslations().contains(this.compareTranslationByUser)) continue;
            this.correct = true;
            this.correctVocable = vocable;
            break;
        }
    }

    private void checkGermanToJapanese() {
        this.correct = false;
        for (Vocable vocable : this.matchingVocables) {
            if (!vocable.getCompareKana().equals(this.compareTranslationByUser) && !vocable.getCompareKanji().equals(this.compareTranslationByUser) && !vocable.getCompareRomaji().equals(this.compareTranslationByUser)) continue;
            this.correct = true;
            this.correctVocable = vocable;
            break;
        }
    }

    public boolean isCorrect() {
        return this.correct;
    }

    public Vocable getCorrectVocable() {
        return this.correctVocable;
    }
}

