/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic.steps;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.text.NumberString;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.io.VocabularyDirectoryReader;
import de.duehl.vocabulary.japanese.startup.logic.steps.StartupStep;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import java.util.List;

public class Step01ReadVocabularies
extends StartupStep {
    private List<Vocabulary> vocabularies;
    private String vocabularyLoadMessage;
    private int numberOfVocables;
    private int numberOfPhrases;

    public Step01ReadVocabularies(String string, Options options, SplashScreenable splashScreenable, StopWatch stopWatch) {
        super(string, options, splashScreenable, stopWatch);
    }

    @Override
    protected void runInternalStep() {
        this.readVocabularies();
        this.createAndAppendLoadUpMessage();
        this.storeVocabularyDescriptionIntoVocable();
    }

    private void readVocabularies() {
        this.appendMessage("Lese Vokabularien ein ...");
        String string = this.options.getVocabulariesPath();
        VocabularyDirectoryReader vocabularyDirectoryReader = new VocabularyDirectoryReader(string);
        vocabularyDirectoryReader.read();
        this.vocabularies = vocabularyDirectoryReader.getVocabularies();
    }

    private void createAndAppendLoadUpMessage() {
        this.numberOfVocables = 0;
        this.numberOfPhrases = 0;
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                ++this.numberOfVocables;
                if (!vocable.getPartsOfSpeech().contains("Phrase")) continue;
                ++this.numberOfPhrases;
            }
        }
        this.vocabularyLoadMessage = "Es wurden " + NumberString.taupu(this.vocabularies.size()) + " Vokabulare mit zusammen " + NumberString.taupu(this.numberOfVocables) + " Vokabeln (davon " + NumberString.taupu(this.numberOfPhrases) + " Phrasen) eingelesen.";
        this.appendMessage(this.vocabularyLoadMessage);
    }

    private void storeVocabularyDescriptionIntoVocable() {
        for (Vocabulary vocabulary : this.vocabularies) {
            String string = vocabulary.getDescription();
            for (Vocable vocable : vocabulary.getVocables()) {
                vocable.setVocabularyDescription(string);
            }
        }
    }

    public List<Vocabulary> getVocabularies() {
        return this.vocabularies;
    }

    public String getVocabularyLoadMessage() {
        return this.vocabularyLoadMessage;
    }

    public int getNumberOfVocables() {
        return this.numberOfVocables;
    }

    public int getNumberOfPhrases() {
        return this.numberOfPhrases;
    }
}

