/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.data.symbol.KanaSubType;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.data.HiraganaForTestSelectionMethod;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class HiraganaTestParameterChooser
extends ModalDialogBase {
    private static final int MIN_WIDTH = 500;
    private final List<Hiragana> notTenTimesGoodTestedHiraganaList;
    private boolean applied;
    private final JCheckBox useOriginalHiraganaOrderCheckBox;
    private final JRadioButton fiveHiraganaRadioButton;
    private final JRadioButton tenHiraganaRadioButton;
    private final JRadioButton fifteenHiraganaRadioButton;
    private final JRadioButton twenytHiraganaRadioButton;
    private final JRadioButton thirtyHiraganaRadioButton;
    private final JRadioButton fiftyHiraganaRadioButton;
    private final JRadioButton allHiraganaRadioButton;
    private final JRadioButton notTenTimesGoodTestedHiraganaRadioButton;
    private final JRadioButton lastThirtyHiraganaRadioButton;
    private final JRadioButton lastTwentyHiraganaRadioButton;
    private final JRadioButton lastFifteenHiraganaRadioButton;
    private final JRadioButton lastTenHiraganaRadioButton;
    private final JRadioButton lastFiveHiraganaRadioButton;
    private final List<JCheckBox> subTypCheckboxes;
    private final Map<JCheckBox, KanaSubType> subTypeCheckBoxToType;
    private final JButton okButton;
    private int numberOfHiraganaToTest;
    private boolean useOriginalHiraganaOrder;
    private HiraganaForTestSelectionMethod selectionMethod;
    private List<Hiragana> hiraganaList;

    public HiraganaTestParameterChooser(List<Hiragana> list, Point point, Image image) {
        super(point, image, "Die Parameter f\u00fcr den Hiragana-Test ausw\u00e4hlen");
        this.notTenTimesGoodTestedHiraganaList = list;
        this.useOriginalHiraganaOrderCheckBox = new JCheckBox("in Originalreihenfolge");
        this.fiveHiraganaRadioButton = new JRadioButton("5 Hiragana");
        this.tenHiraganaRadioButton = new JRadioButton("10 Hiragana");
        this.fifteenHiraganaRadioButton = new JRadioButton("15 Hiragana");
        this.twenytHiraganaRadioButton = new JRadioButton("20 Hiragana");
        this.thirtyHiraganaRadioButton = new JRadioButton("30 Hiragana");
        this.fiftyHiraganaRadioButton = new JRadioButton("50 Hiragana");
        this.allHiraganaRadioButton = new JRadioButton("Alle Hiragana (" + NumberString.taupu(Hiragana.getNumberOfKnownHiragana()) + ")");
        this.notTenTimesGoodTestedHiraganaRadioButton = new JRadioButton("nicht zuletzt zehn mal richtig abgefragte Hiragana");
        this.lastThirtyHiraganaRadioButton = new JRadioButton("die letzten 30 Hiragana");
        this.lastTwentyHiraganaRadioButton = new JRadioButton("die letzten 20 Hiragana");
        this.lastFifteenHiraganaRadioButton = new JRadioButton("die letzten 15 Hiragana");
        this.lastTenHiraganaRadioButton = new JRadioButton("die letzten 10 Hiragana");
        this.lastFiveHiraganaRadioButton = new JRadioButton("die letzten 5 Hiragana");
        this.subTypCheckboxes = new ArrayList<JCheckBox>();
        this.subTypeCheckBoxToType = new HashMap<JCheckBox, KanaSubType>();
        this.okButton = new JButton();
        this.selectionMethod = HiraganaForTestSelectionMethod.UNKNOWN;
        this.applied = false;
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.initRadioButtons();
        this.initCheckBoxes();
        this.initSubTypeCheckBoxes();
        this.addSubTypeCheckBoxesActionListener();
        this.subTypesSelectionChanged();
    }

    private void initRadioButtons() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fiveHiraganaRadioButton);
        buttonGroup.add(this.tenHiraganaRadioButton);
        buttonGroup.add(this.fifteenHiraganaRadioButton);
        buttonGroup.add(this.twenytHiraganaRadioButton);
        buttonGroup.add(this.thirtyHiraganaRadioButton);
        buttonGroup.add(this.fiftyHiraganaRadioButton);
        buttonGroup.add(this.allHiraganaRadioButton);
        buttonGroup.add(this.notTenTimesGoodTestedHiraganaRadioButton);
        buttonGroup.add(this.lastThirtyHiraganaRadioButton);
        buttonGroup.add(this.lastTwentyHiraganaRadioButton);
        buttonGroup.add(this.lastFifteenHiraganaRadioButton);
        buttonGroup.add(this.lastTenHiraganaRadioButton);
        buttonGroup.add(this.lastFiveHiraganaRadioButton);
        this.allHiraganaRadioButton.setSelected(true);
    }

    private void initCheckBoxes() {
        this.useOriginalHiraganaOrderCheckBox.setSelected(false);
    }

    private void initSubTypeCheckBoxes() {
        for (KanaSubType kanaSubType : KanaSubType.values()) {
            JCheckBox jCheckBox = new JCheckBox(kanaSubType.getDescription());
            jCheckBox.setSelected(kanaSubType == KanaSubType.STANDARD || kanaSubType == KanaSubType.WITH_DAKUTEN || kanaSubType == KanaSubType.WITH_HANDAKUTEN || kanaSubType == KanaSubType.COMPOUND || kanaSubType == KanaSubType.COMPOUND_WITH_DAKUTEN || kanaSubType == KanaSubType.COMPOUND_WITH_HANDAKUTEN);
            this.subTypCheckboxes.add(jCheckBox);
            this.subTypeCheckBoxToType.put(jCheckBox, kanaSubType);
        }
    }

    private void addSubTypeCheckBoxesActionListener() {
        for (JCheckBox jCheckBox : this.subTypCheckboxes) {
            jCheckBox.addActionListener(actionEvent -> this.subTypesSelectionChanged());
        }
    }

    private void subTypesSelectionChanged() {
        List<Hiragana> list = this.createHiraganaListWithSelecetdSubtypes();
        int n = list.size();
        this.allHiraganaRadioButton.setText("Alle Hiragana (" + NumberString.taupu(n) + ")");
        int n2 = this.notTenTimesGoodTestedHiraganaList.size();
        this.notTenTimesGoodTestedHiraganaRadioButton.setText("nicht zuletzt zehn mal richtig abgefragte Hiragana (" + n2 + ")");
        this.notTenTimesGoodTestedHiraganaRadioButton.setEnabled(!this.notTenTimesGoodTestedHiraganaList.isEmpty());
        this.handleRadioButton(this.fiveHiraganaRadioButton, 5, n);
        this.handleRadioButton(this.tenHiraganaRadioButton, 10, n);
        this.handleRadioButton(this.fifteenHiraganaRadioButton, 15, n);
        this.handleRadioButton(this.twenytHiraganaRadioButton, 20, n);
        this.handleRadioButton(this.thirtyHiraganaRadioButton, 30, n);
        this.handleRadioButton(this.fiftyHiraganaRadioButton, 50, n);
        this.handleRadioButton(this.lastThirtyHiraganaRadioButton, 30, n);
        this.handleRadioButton(this.lastTwentyHiraganaRadioButton, 20, n);
        this.handleRadioButton(this.lastFifteenHiraganaRadioButton, 15, n);
        this.handleRadioButton(this.lastTenHiraganaRadioButton, 10, n);
        this.handleRadioButton(this.lastFiveHiraganaRadioButton, 5, n);
    }

    private void handleRadioButton(JRadioButton jRadioButton, int n, int n2) {
        jRadioButton.setEnabled(n2 >= n);
        if (n2 < n && jRadioButton.isSelected()) {
            jRadioButton.setSelected(false);
        }
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        SwingUtilities.invokeLater(() -> this.okButton.requestFocus());
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createHiraganaSubTypeSelectionPart(), "North");
        jPanel.add(this.createNumberOfHiraganaPart(), "Center");
        jPanel.add(this.createSortHiraganaPart(), "South");
        return jPanel;
    }

    private Component createHiraganaSubTypeSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createTitle("Unterarten", jPanel);
        for (JCheckBox jCheckBox : this.subTypCheckboxes) {
            jPanel.add(jCheckBox);
        }
        return jPanel;
    }

    private Component createNumberOfHiraganaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createNumberOfRandomSelectedHiraganaPart());
        jPanel.add(this.createNumberOfLastXHiraganaPart());
        jPanel.add(this.createNumberOfAllHiraganaPart());
        jPanel.add(this.createNumberOfNotTenTimesGoodTestedHiraganaPart());
        jPanel.add(this.createDummyMinWidthLabelPart());
        return jPanel;
    }

    private Component createNumberOfRandomSelectedHiraganaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("F\u00fcr die Abfrage der Hiragana die folgende Anzahl zuf\u00e4llig ausgew\u00e4hen", jPanel);
        jPanel.add(this.fiveHiraganaRadioButton);
        jPanel.add(this.tenHiraganaRadioButton);
        jPanel.add(this.fifteenHiraganaRadioButton);
        jPanel.add(this.twenytHiraganaRadioButton);
        jPanel.add(this.thirtyHiraganaRadioButton);
        jPanel.add(this.fiftyHiraganaRadioButton);
        return jPanel;
    }

    private Component createNumberOfLastXHiraganaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("F\u00fcr die Abfrage der Hiragana die folgende Anzahl der zuletzt hinzugef\u00fcgten ausgew\u00e4hen", jPanel);
        jPanel.add(this.lastThirtyHiraganaRadioButton);
        jPanel.add(this.lastTwentyHiraganaRadioButton);
        jPanel.add(this.lastFifteenHiraganaRadioButton);
        jPanel.add(this.lastTenHiraganaRadioButton);
        jPanel.add(this.lastFiveHiraganaRadioButton);
        return jPanel;
    }

    private Component createNumberOfAllHiraganaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("Alle Hiragana abfragen", jPanel);
        jPanel.add(this.allHiraganaRadioButton);
        return jPanel;
    }

    private Component createNumberOfNotTenTimesGoodTestedHiraganaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("Nicht zehn mal richtig beantwortete Hiragana abfragen", jPanel);
        jPanel.add(this.notTenTimesGoodTestedHiraganaRadioButton);
        return jPanel;
    }

    private Component createDummyMinWidthLabelPart() {
        JLabel jLabel = new JLabel("");
        jLabel.setPreferredSize(new Dimension(500, 0));
        return jLabel;
    }

    private Component createSortHiraganaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Sortierung", jPanel);
        jPanel.add((Component)this.useOriginalHiraganaOrderCheckBox, "Center");
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }

    private Component createOkButton() {
        this.okButton.setText("   Abfrage starten   ");
        GuiTools.biggerFont(this.okButton, 5);
        this.okButton.addActionListener(actionEvent -> this.apply());
        return this.okButton;
    }

    private List<Hiragana> createHiraganaListWithSelecetdSubtypes() {
        ArrayList<KanaSubType> arrayList = new ArrayList<KanaSubType>();
        for (JCheckBox hiraganaArray : this.subTypCheckboxes) {
            if (!hiraganaArray.isSelected()) continue;
            if (!this.subTypeCheckBoxToType.containsKey(hiraganaArray)) {
                throw new RuntimeException("Zur subTypeCheckBox '" + hiraganaArray.getText() + "' ist der Typ nicht bekannt!");
            }
            KanaSubType kanaSubType = this.subTypeCheckBoxToType.get(hiraganaArray);
            if (arrayList.contains((Object)kanaSubType)) continue;
            arrayList.add(kanaSubType);
        }
        ArrayList arrayList2 = new ArrayList();
        for (Hiragana hiragana : Hiragana.values()) {
            KanaSubType kanaSubType = hiragana.getSubType();
            if (!arrayList.contains((Object)kanaSubType)) continue;
            arrayList2.add(hiragana);
        }
        return arrayList2;
    }

    private void apply() {
        this.hiraganaList = this.createHiraganaListWithSelecetdSubtypes();
        if (this.fiveHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 5;
            this.selectionMethod = HiraganaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.tenHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 10;
            this.selectionMethod = HiraganaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.fifteenHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 15;
            this.selectionMethod = HiraganaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.twenytHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 20;
            this.selectionMethod = HiraganaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.thirtyHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 30;
            this.selectionMethod = HiraganaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.fiftyHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 50;
            this.selectionMethod = HiraganaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.allHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = Hiragana.getNumberOfKnownHiragana();
            this.selectionMethod = HiraganaForTestSelectionMethod.ALL;
        } else if (this.notTenTimesGoodTestedHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = this.notTenTimesGoodTestedHiraganaList.size();
            this.selectionMethod = HiraganaForTestSelectionMethod.NOT_TEN_TIMES_GOOD_TESTED;
        } else if (this.lastThirtyHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 30;
            this.selectionMethod = HiraganaForTestSelectionMethod.LAST_N;
        } else if (this.lastTwentyHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 20;
            this.selectionMethod = HiraganaForTestSelectionMethod.LAST_N;
        } else if (this.lastFifteenHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 15;
            this.selectionMethod = HiraganaForTestSelectionMethod.LAST_N;
        } else if (this.lastTenHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 10;
            this.selectionMethod = HiraganaForTestSelectionMethod.LAST_N;
        } else if (this.lastFiveHiraganaRadioButton.isSelected()) {
            this.numberOfHiraganaToTest = 5;
            this.selectionMethod = HiraganaForTestSelectionMethod.LAST_N;
        } else {
            this.numberOfHiraganaToTest = -1;
            this.selectionMethod = HiraganaForTestSelectionMethod.UNKNOWN;
            String string = "Keine Anzahl an Hiragana ausgew\u00e4hlt";
            String string2 = "Sie haben die Anzahl der abzufragenden Hiragana nicht ausgew\u00e4hlt.";
            GuiTools.informUser(this.getWindowAsComponent(), string, string2);
            return;
        }
        this.useOriginalHiraganaOrder = this.useOriginalHiraganaOrderCheckBox.isSelected();
        this.applied = true;
        this.quit();
    }

    public boolean isApplied() {
        return this.applied;
    }

    public List<Hiragana> getHiraganaList() {
        return this.hiraganaList;
    }

    public int getNumberOfHiraganaToTest() {
        return this.numberOfHiraganaToTest;
    }

    public boolean isUseOriginalHiraganaOrder() {
        return this.useOriginalHiraganaOrder;
    }

    public HiraganaForTestSelectionMethod getSelectionMethod() {
        return this.selectionMethod;
    }
}

