/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.TextAreaSelection;
import de.duehl.swing.ui.components.selections.tools.SelectionsHelper;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.key.BindKeysOnRootPane;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.data.SingleUserInputKatakanaCheckResult;
import de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest.components.KatakanaPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class KatakanaTestEvaluationDialog
extends ModalDialogBase {
    private static final int MIN_WIDTH = 700;
    private final SingleUserInputKatakanaCheckResult result;
    private final Katakana katakana;
    private final boolean correct;
    private final String message;
    private final Color backgroundColor;
    private final KatakanaPanel katakanaPanel;
    private final JButton quitButton;
    private boolean onlyTypingError;
    private final StringSelection userInputHepburnSelection;
    private final TextAreaSelection errorMessageSelection;
    private boolean errorFilled;

    public KatakanaTestEvaluationDialog(SingleUserInputKatakanaCheckResult singleUserInputKatakanaCheckResult, String string, Options options, Point point, Image image) {
        super(point, image, singleUserInputKatakanaCheckResult.isOk() ? "Richtig!" : "Leider falsch");
        this.addEscapeBehaviour();
        this.result = singleUserInputKatakanaCheckResult;
        this.katakana = singleUserInputKatakanaCheckResult.getKatakana();
        this.correct = singleUserInputKatakanaCheckResult.isOk();
        this.onlyTypingError = false;
        this.message = this.correct ? "Richtig beantwortet, sehr gut!" : "Das war leider nicht richtig";
        VocableColors vocableColors = new VocableColors(options);
        this.backgroundColor = this.correct ? vocableColors.getSuccessColor() : vocableColors.getFailureColor();
        this.quitButton = new JButton("Beenden");
        this.katakanaPanel = new KatakanaPanel();
        this.userInputHepburnSelection = new StringSelection("Eingebene Hepburn-Darstellung");
        this.errorMessageSelection = new TextAreaSelection("Fehlermeldungen");
        this.init(string);
        this.fillDialog();
    }

    private void init(String string) {
        this.initKatakanaPanel();
        this.fillKatakanaPanel();
        this.initUserInputTextSelectionms();
        this.fillUserInputTextSelections(string);
        this.initResultTextSelections();
        this.fillResultTextSelections();
        this.initQuitButton();
    }

    private void initKatakanaPanel() {
        this.katakanaPanel.createGui();
    }

    private void fillKatakanaPanel() {
        this.katakanaPanel.showKatakana(this.katakana);
    }

    private void initUserInputTextSelectionms() {
        SelectionsHelper.initSelectionAsViewer(this.userInputHepburnSelection);
    }

    private void fillUserInputTextSelections(String string) {
        this.userInputHepburnSelection.setText(string);
    }

    private void initResultTextSelections() {
        SelectionsHelper.initSelectionAsViewer(this.errorMessageSelection);
    }

    private void fillResultTextSelections() {
        String string = this.result.getErrorDescription();
        this.errorMessageSelection.setText(string);
        this.errorFilled = !string.isBlank();
    }

    private void initQuitButton() {
        GuiTools.addReturnListener(this.quitButton, () -> this.quitButton.doClick());
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        if (!this.correct) {
            this.keybindingsForOnlyTypingError();
        }
        SwingUtilities.invokeLater(() -> this.quitButton.requestFocus());
        this.pack();
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createMessagePart());
        jPanel.add(this.createKatakanaDataPart());
        jPanel.add(this.createUserDataPart());
        if (this.errorFilled) {
            jPanel.add(this.createErrorMesagePart());
        }
        if (!this.correct) {
            jPanel.add(this.createOnlyTypingErrorLabel());
        }
        return GuiTools.createScrollPane(jPanel);
    }

    private Component createMessagePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createMessageLabel(), "Center");
        return jPanel;
    }

    private Component createMessageLabel() {
        JLabel jLabel = new JLabel(this.message);
        jLabel.setHorizontalAlignment(0);
        jLabel.setPreferredSize(new Dimension(700, 30));
        GuiTools.biggerFont(jLabel, 7);
        jLabel.setOpaque(true);
        jLabel.setBackground(this.backgroundColor);
        return jLabel;
    }

    private Component createKatakanaDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createBlueTitle("Daten zum abgefragten Katakana:", jPanel);
        jPanel.add(this.katakanaPanel.getPanel());
        return jPanel;
    }

    private Component createUserDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createBlueTitle("Vom Benutzer eingegebene Daten:", jPanel);
        jPanel.add(this.userInputHepburnSelection.getPanel());
        return jPanel;
    }

    private Component createErrorMesagePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createBlueTitle("Fehler und Hinweise:", jPanel);
        if (this.errorFilled) {
            jPanel.add(this.errorMessageSelection.getPanel());
        }
        return jPanel;
    }

    private Component createOnlyTypingErrorLabel() {
        JLabel jLabel = new JLabel("War es nur ein Tippfehler? Dann Strg-Shift-K dr\u00fccken.");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return jLabel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        this.quitButton.addActionListener(actionEvent -> this.closeDialog());
        this.quitButton.setBackground(this.backgroundColor);
        return this.quitButton;
    }

    private void keybindingsForOnlyTypingError() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(75, 192);
        String string = "Strg-Shift-K";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.setToOnlyTypingError());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private void setToOnlyTypingError() {
        String string = "War es nur ein Tippfehler?";
        String string2 = "War die falsche Eingabe wirklich nur ein Tippfehler?\nBitte gewissenhaft antworten und sich nicht selbst bel\u00fcgen.";
        this.onlyTypingError = GuiTools.askUser(this.getWindowAsComponent(), string, string2);
        if (this.onlyTypingError) {
            this.closeDialog();
        }
    }

    public boolean wasOnlyTypingError() {
        return this.onlyTypingError;
    }
}

