/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.related;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.grammar.VerbSearchWords;
import de.duehl.vocabulary.japanese.grammar.find.RelatedVocablesFinder;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.lister.VocabularyListerDialog;
import java.awt.Point;
import java.util.List;

class VerbsAndAdjectivesFinder {
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final Point location;
    private final LongTimeProcessInformer longTimeProcessInformer;

    public VerbsAndAdjectivesFinder(FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point, LongTimeProcessInformer longTimeProcessInformer) {
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.location = point;
        this.longTimeProcessInformer = longTimeProcessInformer;
    }

    public void findRelatedVerbs(Vocable vocable2) {
        RelatedVocablesFinder relatedVocablesFinder = new RelatedVocablesFinder(this.dataStructures.getVocabularies(), vocable2, vocable -> vocable.isVerb());
        relatedVocablesFinder.find();
        List<Vocable> list = relatedVocablesFinder.getRelatedVocables();
        String string = "Verbformen zum Verb " + vocable2.getKanjiKanaRomajiWithJapaneseBraces();
        VerbSearchWords.sortVocablesByVerbForms(list);
        this.listVocables(list, string);
    }

    public void findRelatedAdjectives(Vocable vocable2) {
        RelatedVocablesFinder relatedVocablesFinder = new RelatedVocablesFinder(this.dataStructures.getVocabularies(), vocable2, vocable -> vocable.isAdjective());
        relatedVocablesFinder.find();
        List<Vocable> list = relatedVocablesFinder.getRelatedVocables();
        String string = "Adjektivformen zum Adjektiv " + vocable2.getKanjiKanaRomajiWithJapaneseBraces();
        VerbSearchWords.sortVocablesByVerbForms(list);
        this.listVocables(list, string);
    }

    private void listVocables(List<Vocable> list, String string) {
        VocabularyListerDialog vocabularyListerDialog = new VocabularyListerDialog(list, string, this.dataStructures, this.uiObjects, this.location, this.longTimeProcessInformer);
        vocabularyListerDialog.setVisible(true);
    }
}

