/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.listcommander.selector.history;

import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.persistence.data.HistoricalOwnListPersistanceDataList;
import de.duehl.vocabulary.japanese.common.persistence.data.OwnListPersistanceData;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OwnListHistoryDialog
extends ModalDialogBase {
    private final HistoricalOwnListPersistanceDataList historicalOwnLists;
    private boolean validSelection;
    private OwnListPersistanceData selectedPersistentOwnList;

    public OwnListHistoryDialog(HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList, Point point, Image image) {
        super(point, image, "Historie der eigenen Listen");
        this.addEscapeBehaviour();
        this.historicalOwnLists = historicalOwnListPersistanceDataList;
        this.validSelection = false;
        this.fillDialog();
    }

    @Override
    protected void populateDialog() {
        this.add(this.createHistoricalPart(), "Center");
    }

    private Component createHistoricalPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(2, 3));
        List<OwnListPersistanceData> list = this.historicalOwnLists.getHistoricalOwnLists();
        for (OwnListPersistanceData ownListPersistanceData : list) {
            jPanel.add(this.createPersistentOwnListButton(ownListPersistanceData));
        }
        return jPanel;
    }

    private Component createPersistentOwnListButton(OwnListPersistanceData ownListPersistanceData) {
        String string = ownListPersistanceData.getCategory() + " - " + ownListPersistanceData.getSubCategory() + " - " + ownListPersistanceData.getName();
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionEvent -> this.selectList(ownListPersistanceData));
        return jButton;
    }

    private void selectList(OwnListPersistanceData ownListPersistanceData) {
        this.validSelection = true;
        this.selectedPersistentOwnList = ownListPersistanceData;
        this.closeDialog();
    }

    public boolean isValidSelection() {
        return this.validSelection;
    }

    public OwnListPersistanceData getSelectedPersistentOwnList() {
        return this.selectedPersistentOwnList;
    }
}

