/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.tabs;

import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.components.bars.VocabularyBar;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.tabs.SubCategoryTabs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTabbedPane;

public class CategoryTabs {
    private final List<String> categories;
    private final List<? extends Vocabulary> vocabularies;
    private final VocabularyTrainerLogic logic;
    private final VocabularyTrainerGui gui;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final JTabbedPane categoryTabs;
    private final Map<String, List<Vocabulary>> vocabulariesByCategoryMap;
    private final List<SubCategoryTabs> subCategoryTabsList;

    public CategoryTabs(List<String> list, List<? extends Vocabulary> list2, VocabularyTrainerLogic vocabularyTrainerLogic, VocabularyTrainerGui vocabularyTrainerGui, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        this.categories = list;
        this.vocabularies = list2;
        this.logic = vocabularyTrainerLogic;
        this.gui = vocabularyTrainerGui;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.vocabulariesByCategoryMap = this.createVocabulariesByCategoryMap();
        this.subCategoryTabsList = new ArrayList<SubCategoryTabs>();
        this.categoryTabs = new JTabbedPane();
        this.populateCategoryTabs();
    }

    private Map<String, List<Vocabulary>> createVocabulariesByCategoryMap() {
        HashMap<String, List<Vocabulary>> hashMap = new HashMap<String, List<Vocabulary>>();
        for (Vocabulary vocabulary : this.vocabularies) {
            String string = vocabulary.getCategory();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            List list = (List)hashMap.get(string);
            list.add(vocabulary);
        }
        return hashMap;
    }

    private void populateCategoryTabs() {
        for (String string : this.categories) {
            this.populateForCategory(string);
        }
    }

    private void populateForCategory(String string) {
        if (!this.vocabulariesByCategoryMap.containsKey(string)) {
            throw new RuntimeException("Zur Kategorie '" + string + "' wurde keine Liste an Vokabularien gefunden.");
        }
        List<Vocabulary> list = this.vocabulariesByCategoryMap.get(string);
        List<String> list2 = VocabularyTools.determineSubCategoriesOfCategory(list, string);
        SubCategoryTabs subCategoryTabs = new SubCategoryTabs(list2, list, this.logic, this.gui, this.dataStructures, this.uiObjects);
        this.categoryTabs.add(string, subCategoryTabs.getSubCategoryTabs());
        this.subCategoryTabsList.add(subCategoryTabs);
    }

    public void showTabsWeViewedLastTime(String string) {
        int n;
        Options options = this.dataStructures.getOptions();
        if (string.equals("Vocabulary")) {
            n = options.getLastShownVocabularyCategoryTabIndex();
        } else if (string.equals("OwnList")) {
            n = options.getLastShownOwnListCategoryTabIndex();
        } else {
            throw new RuntimeException("Unbekannter lastShownTabIndexType '" + string + "'.");
        }
        if (n >= 0 && n < this.categoryTabs.getTabCount()) {
            this.categoryTabs.setSelectedIndex(n);
            SubCategoryTabs subCategoryTabs = this.subCategoryTabsList.get(n);
            subCategoryTabs.showTabsWeViewedLastTime(string);
        }
    }

    public void storeShownTabIndices(Options options, String string) {
        int n = this.categoryTabs.getSelectedIndex();
        if (n != -1) {
            if (string.equals("Vocabulary")) {
                options.setLastShownVocabularyCategoryTabIndex(n);
            } else if (string.equals("OwnList")) {
                options.setLastShownOwnListCategoryTabIndex(n);
            } else {
                throw new RuntimeException("Unbekannter lastShownTabIndexType '" + string + "'.");
            }
            SubCategoryTabs subCategoryTabs = this.subCategoryTabsList.get(n);
            subCategoryTabs.storeShownTabIndices(options, string);
        }
    }

    public List<Vocable> collectVocablesOfSelectedVocabularies() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            arrayList.addAll(subCategoryTabs.collectVocablesOfSelectedVocabularies());
        }
        return arrayList;
    }

    public void showVocabularyBarsInWantedOrder() {
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            subCategoryTabs.showVocabularyBarsInWantedOrder();
        }
    }

    public void showOrHideIndividualVocabularySortModeMoveButtons() {
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            subCategoryTabs.showOrHideIndividualVocabularySortModeMoveButtons();
        }
    }

    public List<Vocabulary> getVocabulariesInIndividualOrder() {
        ArrayList<Vocabulary> arrayList = new ArrayList<Vocabulary>();
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            arrayList.addAll(subCategoryTabs.getVocabularyBarsInIndividualOrder());
        }
        return arrayList;
    }

    public List<OwnList> getOwnListsInIndividualOrder() {
        ArrayList<OwnList> arrayList = new ArrayList<OwnList>();
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            arrayList.addAll(subCategoryTabs.getOwnListsInIndividualOrder());
        }
        return arrayList;
    }

    public List<VocabularyBar> determineBarsOfSelectedTab() {
        int n = this.categoryTabs.getSelectedIndex();
        SubCategoryTabs subCategoryTabs = this.subCategoryTabsList.get(n);
        return subCategoryTabs.determineBarsOfSelectedTab();
    }

    public void setCorrectForegroundColorOfVocabularyBars() {
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            subCategoryTabs.setCorrectForegroundColorOfVocabularyBars();
        }
    }

    public void setCorrectTextOfVocabularyBars() {
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            subCategoryTabs.setCorrectTextOfVocabularyBars();
        }
    }

    public void showOrHidePercentInVocabularyBarsLater() {
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            subCategoryTabs.showOrHidePercentInVocabularyBarsLater();
        }
    }

    public JTabbedPane getCategoryTabs() {
        return this.categoryTabs;
    }

    public void showTranslationDirectionOnBarButtons() {
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            subCategoryTabs.showTranslationDirectionOnBarButtons();
        }
    }

    public void toggleShowOwnListButtons() {
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            subCategoryTabs.toggleShowOwnListButtons();
        }
    }

    public void showTestViewListSheetButtons() {
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            subCategoryTabs.showTestViewListSheetButtons();
        }
    }

    public void showOwnListExtraButtons() {
        for (SubCategoryTabs subCategoryTabs : this.subCategoryTabsList) {
            subCategoryTabs.showOwnListExtraButtons();
        }
    }
}

