package de.duehl.basics.io.textfile;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.Charset;

/**
 * Diese Klasse liest eine Liste mit den Texten aus den Zeilen einer Textdatei in einer Jar ein.
 *
 * Die Zeilen werden getrimmt. Dabei werden leere Zeilen und solche, die mit dem Kommentarzeichen
 * (ggf., nach Leerraum) überlesen. Kommt in einer Datenzeile weiter hinten das Kommentarzeichen
 * vor, so wird ab dort abgeschnitten und getrimmt.
 *
 * Der Zeileninhalt wird dann als Komma-getrennte Liste verarbeitet.
 *
 * @version 1.01     2019-03-21
 * @author Christian Dühl
 */

public class ListsFromTextFileInJarReader extends ListsFromTextFileReader {

    /**
     * Konstruktor.
     *
     * @param filename
     *            Name der einzulesenden Datei ohne Pfad.
     * @param charset
     *            Kodierung der einzulesenden Datei.
     * @param clazz
     *            Klasse neben der die Datei sich im befindet.
     * @param commentChar
     *            Das Kommentarzeichen.
     */
    public ListsFromTextFileInJarReader(String filename, Charset charset, Class<?> clazz,
            String commentChar) {
        super(new StringsFromTextFileInJarReader(filename, charset, clazz, commentChar));
    }

}
