package de.duehl.basics.datetime.date;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

public class WeekdayTest {

    @Test
    public void getWeekdayByDayCodeStartingSunday0() {
        int dayCode = 0;
        Weekday actual = Weekday.getWeekdayByDayCodeStartingSunday(dayCode);
        Weekday expected = Weekday.SUNDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCodeStartingSunday1() {
        int dayCode = 1;
        Weekday actual = Weekday.getWeekdayByDayCodeStartingSunday(dayCode);
        Weekday expected = Weekday.MONDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCodeStartingSunday2() {
        int dayCode = 2;
        Weekday actual = Weekday.getWeekdayByDayCodeStartingSunday(dayCode);
        Weekday expected = Weekday.TUESDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCodeStartingSunday3() {
        int dayCode = 3;
        Weekday actual = Weekday.getWeekdayByDayCodeStartingSunday(dayCode);
        Weekday expected = Weekday.WEDNESDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCodeStartingSunday4() {
        int dayCode = 4;
        Weekday actual = Weekday.getWeekdayByDayCodeStartingSunday(dayCode);
        Weekday expected = Weekday.THURSDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCodeStartingSunday5() {
        int dayCode = 5;
        Weekday actual = Weekday.getWeekdayByDayCodeStartingSunday(dayCode);
        Weekday expected = Weekday.FRIDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCodeStartingSunday6() {
        int dayCode = 6;
        Weekday actual = Weekday.getWeekdayByDayCodeStartingSunday(dayCode);
        Weekday expected = Weekday.SATURDAY;
        assertEquals(expected, actual);
    }

    @Test (expected = IllegalArgumentException.class)
    public void getWeekdayByDayCodeStartingSundayToBig() {
        int dayCode = 7;
        Weekday.getWeekdayByDayCodeStartingSunday(dayCode);
    }

    @Test (expected = IllegalArgumentException.class)
    public void getWeekdayByDayCodeStartingSundayToSmall() {
        int dayCode = -1;
        Weekday.getWeekdayByDayCodeStartingSunday(dayCode);
    }

    @Test
    public void getWeekdayByDayCode0() {
        int dayCode = 0;
        Weekday actual = Weekday.getWeekdayByDayCode(dayCode);
        Weekday expected = Weekday.MONDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCode1() {
        int dayCode = 1;
        Weekday actual = Weekday.getWeekdayByDayCode(dayCode);
        Weekday expected = Weekday.TUESDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCode2() {
        int dayCode = 2;
        Weekday actual = Weekday.getWeekdayByDayCode(dayCode);
        Weekday expected = Weekday.WEDNESDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCode3() {
        int dayCode = 3;
        Weekday actual = Weekday.getWeekdayByDayCode(dayCode);
        Weekday expected = Weekday.THURSDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCode4() {
        int dayCode = 4;
        Weekday actual = Weekday.getWeekdayByDayCode(dayCode);
        Weekday expected = Weekday.FRIDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCode5() {
        int dayCode = 5;
        Weekday actual = Weekday.getWeekdayByDayCode(dayCode);
        Weekday expected = Weekday.SATURDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void getWeekdayByDayCode6() {
        int dayCode = 6;
        Weekday actual = Weekday.getWeekdayByDayCode(dayCode);
        Weekday expected = Weekday.SUNDAY;
        assertEquals(expected, actual);
    }

    @Test (expected = IllegalArgumentException.class)
    public void getWeekdayByDayCodeToBig() {
        int dayCode = 7;
        Weekday.getWeekdayByDayCode(dayCode);
    }

    @Test (expected = IllegalArgumentException.class)
    public void getWeekdayByDayCodeToSmall() {
        int dayCode = -1;
        Weekday.getWeekdayByDayCode(dayCode);
    }

    @Test
    public void determineByGermanNameMontag() {
        String germanName = "Montag";
        Weekday actual = Weekday.determineByGermanName(germanName);
        Weekday expected = Weekday.MONDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void determineByGermanNameDienstag() {
        String germanName = "Dienstag";
        Weekday actual = Weekday.determineByGermanName(germanName);
        Weekday expected = Weekday.TUESDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void determineByGermanNameMittwoch() {
        String germanName = "Mittwoch";
        Weekday actual = Weekday.determineByGermanName(germanName);
        Weekday expected = Weekday.WEDNESDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void determineByGermanNameDonnerstag() {
        String germanName = "Donnerstag";
        Weekday actual = Weekday.determineByGermanName(germanName);
        Weekday expected = Weekday.THURSDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void determineByGermanNameFreitag() {
        String germanName = "Freitag";
        Weekday actual = Weekday.determineByGermanName(germanName);
        Weekday expected = Weekday.FRIDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void determineByGermanNameSamstag() {
        String germanName = "Samstag";
        Weekday actual = Weekday.determineByGermanName(germanName);
        Weekday expected = Weekday.SATURDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void determineByGermanNameSonnabend() {
        String germanName = "Sonnabend";
        Weekday actual = Weekday.determineByGermanName(germanName);
        Weekday expected = Weekday.SATURDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void determineByGermanNameSonntag() {
        String germanName = "Sonntag";
        Weekday actual = Weekday.determineByGermanName(germanName);
        Weekday expected = Weekday.SUNDAY;
        assertEquals(expected, actual);
    }

    @Test
    public void determineByGermanNameEmpty() {
        String germanName = "";
        Weekday actual = Weekday.determineByGermanName(germanName);
        Weekday expected = Weekday.UNKNOWN;
        assertEquals(expected, actual);
    }

    @Test
    public void determineByGermanNameUnknown() {
        String germanName = "Unbekannt gibts nicht...";
        Weekday actual = Weekday.determineByGermanName(germanName);
        Weekday expected = Weekday.UNKNOWN;
        assertEquals(expected, actual);
    }


    @Test
    public void createDayListStartingMonday() {
        List<Weekday> list = Weekday.createDayListStartingMonday();
        assertEquals(7, list.size());
        assertEquals(Weekday.MONDAY, list.get(0));
        assertEquals(Weekday.TUESDAY, list.get(1));
        assertEquals(Weekday.WEDNESDAY, list.get(2));
        assertEquals(Weekday.THURSDAY, list.get(3));
        assertEquals(Weekday.FRIDAY, list.get(4));
        assertEquals(Weekday.SATURDAY, list.get(5));
        assertEquals(Weekday.SUNDAY, list.get(6));
    }

    @Test
    public void createGermanNamesListStartingMonday() {
        List<String> list = Weekday.createGermanNamesListStartingMonday();
        assertEquals(7, list.size());
        assertEquals(Weekday.MONDAY.getGermanName(), list.get(0));
        assertEquals(Weekday.TUESDAY.getGermanName(), list.get(1));
        assertEquals(Weekday.WEDNESDAY.getGermanName(), list.get(2));
        assertEquals(Weekday.THURSDAY.getGermanName(), list.get(3));
        assertEquals(Weekday.FRIDAY.getGermanName(), list.get(4));
        assertEquals(Weekday.SATURDAY.getGermanName(), list.get(5));
        assertEquals(Weekday.SUNDAY.getGermanName(), list.get(6));
    }

    @Test
    public void getDayCodeMontag() {
        Weekday weekday = Weekday.MONDAY;
        int actual = weekday.getDayCode();
        int expected = 0;
        assertEquals(expected, actual);
    }

    @Test
    public void getDayCodeDienstag() {
        Weekday weekday = Weekday.TUESDAY;
        int actual = weekday.getDayCode();
        int expected = 1;
        assertEquals(expected, actual);
    }

    @Test
    public void getDayCodeMittwoch() {
        Weekday weekday = Weekday.WEDNESDAY;
        int actual = weekday.getDayCode();
        int expected = 2;
        assertEquals(expected, actual);
    }

    @Test
    public void getDayCodeDonnerstag() {
        Weekday weekday = Weekday.THURSDAY;
        int actual = weekday.getDayCode();
        int expected = 3;
        assertEquals(expected, actual);
    }

    @Test
    public void getDayCodeFreitag() {
        Weekday weekday = Weekday.FRIDAY;
        int actual = weekday.getDayCode();
        int expected = 4;
        assertEquals(expected, actual);
    }

    @Test
    public void getDayCodeSamstag() {
        Weekday weekday = Weekday.SATURDAY;
        int actual = weekday.getDayCode();
        int expected = 5;
        assertEquals(expected, actual);
    }

    @Test
    public void getDayCodeSonntag() {
        Weekday weekday = Weekday.SUNDAY;
        int actual = weekday.getDayCode();
        int expected = 6;
        assertEquals(expected, actual);
    }

    @Test
    public void getDayCodeUnknown() {
        Weekday weekday = Weekday.UNKNOWN;
        int actual = weekday.getDayCode();
        int expected = -1;
        assertEquals(expected, actual);
    }

}
