package de.duehl.basics.io.textfile;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.io.File;

import org.junit.Test;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.textfile.data.Definitions;
import de.duehl.basics.test.TestHelper;

public class DefinitionsFromNormalTextFileReaderTest {

    private final String path;

    public DefinitionsFromNormalTextFileReaderTest() {
        TestHelper testHelper = TestHelper.createForBasics(getClass(), 7);
        path =  testHelper.getTestDataPath() + File.separator;
    }


    /* -------------------------- TESTS -------------------------- */


    @Test
    public void read() {
        DefinitionsFromTextFileReader reader = new DefinitionsFromNormalTextFileReader(
                FileHelper.concatPathes(path, "DefinitionsTestFile.txt"), Charset.UTF_8, "#");
        reader.beQuiet();
        Definitions definitions = reader.read();

        assertEquals(4, definitions.size());

        assertTrue(definitions.containsKey("a"));
        assertTrue(definitions.containsKey("b"));
        assertTrue(definitions.containsKey("c"));
        assertTrue(definitions.containsKey("modus"));

        assertEquals("eins", definitions.getValueByKey("a"));
        assertEquals("zwei", definitions.getValueByKey("b"));
        assertEquals("drei", definitions.getValueByKey("c"));
        assertEquals("komisch", definitions.getValueByKey("modus"));
    }

}
