package de.duehl.swing.ui.elements.progress;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;
import java.awt.Dimension;
import java.awt.SystemColor;

import javax.swing.JProgressBar;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;

/**
 * Diese Klasse ändert die JProgressBar so ab, dass sie auch im
 * NimbusLookAndFeel gut aussieht.
 *
 * @version 1.01     2014-04-17
 * @author Christian Dühl
 */

public class ColoredProgressBar extends JProgressBar {

    private static final long serialVersionUID = -6877782805423561734L;

    /**
     * Konstruktor.
     *
     * @param minimum
     *            Kleinster Wert auf dem Fortschrittsbalken.
     * @param maximum
     *            Größter Wert auf dem Fortschrittsbalken.
     */
    public ColoredProgressBar(int minimum, int maximum) {
        setMinimum(minimum);
        setMaximum(maximum);

        setForeground(SystemColor.window);
        setBackground(SystemColor.window);

        setBorder(new EtchedBorder(EtchedBorder.LOWERED));

        Dimension size = new Dimension(300, 20);
        setPreferredSize(size);
        setMaximumSize(size);
        setMinimumSize(size);

        BasicProgressBarUI ui = new BasicProgressBarUI() {
            @Override
            protected Color getSelectionForeground() {
                return Color.BLACK;
            }

            @Override
            protected Color getSelectionBackground() {
                return Color.BLACK;
            }
        };
        setUI(ui);
    }

}