package de.duehl.swing.ui.highlightingeditor.buttonbar.resources;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.swing.ui.resources.IconLoader;

public class IconDefinitions {

    public static final String FILE_NEW = "FILE_NEW";
    public static final String FILE_LOAD = "FILE_LOAD";
    public static final String FILE_SAVE = "FILE_SAVE";
    public static final String FILE_SAVE_AS = "FILE_SAVE_AS";

    /**
     * Erzeugt einen IconLoader mit allen Bilddefinitionen.
     *
     * @return IconLoader
     */
    public IconLoader createIconLoader() {
        IconLoader iconLoader = new IconLoader(this.getClass(), null); // Kein Programm-Icon!!

        iconLoader.addPictureIdentifier(FILE_NEW, "datei_neu.gif");
        iconLoader.addPictureIdentifier(FILE_LOAD, "datei_oeffnen.gif");
        iconLoader.addPictureIdentifier(FILE_SAVE, "datei_speichern.gif");
        iconLoader.addPictureIdentifier(FILE_SAVE_AS, "datei_speichern_unter.gif");

        return iconLoader;
    }


}
