package de.duehl.swing.ui.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;
import java.awt.GridLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.elements.arrowselector.ArrowSelector;
import de.duehl.swing.ui.elements.arrowselector.ArrowSelectorListener;

/**
 * Diese Klasse testet ArrowSelector-Elemente.
 *
 * Siehe http://forum.byte-welt.net/threads/12503-Eigene-Checkbox-erstellen
 * den Post von Timothy_Truckle.
 *
 * @version 1.01     2014-07-24
 * @author Christian Dühl
 */

public class ArrowSelectorTest {

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new ArrowSelectorTest();
    }

    /** Konstruktor. */
    public ArrowSelectorTest() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                createAndShowGUI();
            }
        });
    }

    /** Erstellt die grafische Oberfläche und zeigt sie an. */
    private void createAndShowGUI() {
        JFrame frame = new JFrame("ArrowSelectorTest");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new GridLayout(0,  1));

        add(frame, "Standard 9 auf beiden Seiten:", new ArrowSelector());
        add(frame, "9 auf beiden Seiten andere Farben:",
                new ArrowSelector(Color.RED, Color.ORANGE));
        add(frame, "3 auf beiden Seiten:", new ArrowSelector(-3, 3));
        add(frame, "3 auf beiden Seiten mit anderen Farben:",
                new ArrowSelector(Color.RED, Color.GREEN, -3, 3));
        add(frame, "5 rechts mit Rechteck:",
                new ArrowSelector(Color.RED, Color.BLACK, 0, 5));
        add(frame, "5 rechts ohne Rechteck:",
                new ArrowSelector(Color.ORANGE, Color.RED, 1, 5));
        add(frame, "4 links ohne Rechteck:", new ArrowSelector(-9, -6));

        frame.pack();
        frame.setVisible(true);
    }

    /**
     * Fügt einen ArrowSelektor zum Frame hinzu.
     *
     * @param frame
     *            Frame, in den eingefügt wird.
     * @param message
     *            Titel des ArrowSelectors.
     * @param arrowSelector
     *            Anzuzeigender ArrowSelektor.
     */
    private void add(final JFrame frame, final String message,
            final ArrowSelector arrowSelector) {
        frame.add(new JLabel(message));
        frame.add(arrowSelector);
        arrowSelector.addArrowSelectorListener(
                new ArrowSelectorListener() {
            @Override
            public void reactOnButtonSelection(int place) {
                System.out.println("Änderung im ArrowSelektor '"
                        + message + "':\n\tAusgewählt ist nun Platz "
                        + place + "!");
            }
        });
    }

}

