package de.duehl.swing.ui.start;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.basics.io.Charset;
import de.duehl.swing.ui.dialogs.CharsetDialog;

/**
 * Diese Klasse testet den Dialog zur Auswahl des Charsets.
 *
 * @version 1.01     2017-12-19
 * @author Christian Dühl
 */

public class CharsetDialogTest {

    private final JFrame frame;

    /** Konstruktor. */
    public CharsetDialogTest() {
        frame = new JFrame("CharsetDialog Test");

        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private void createAndShowGUI() {
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(createOpenDialogButton(), BorderLayout.CENTER);

        frame.setPreferredSize(new Dimension(300, 300));
        frame.pack();
        frame.setVisible(true);
    }

    private Component createOpenDialogButton() {
        JButton button = new JButton("Dialog zur Auswahl des Charsets öffnen");
        button.addActionListener(e ->  createCharsetDialog());
        return button;
    }

    private void createCharsetDialog() {
        CharsetDialog dialog = new CharsetDialog(frame.getLocation(), null, "foo.txt");
        dialog.setVisible(true);
        Charset charset = dialog.getSelectedCharset();
        System.out.println("Ausgewählt wurde: " + charset.getCharsetAsString());
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new CharsetDialogTest();
    }

}

