package de.duehl.twosidecommander.try1.element;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JButton;
import javax.swing.JPanel;

import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.twosidecommander.try1.element.displayer.DemoListElementDisplayer;
import de.duehl.twosidecommander.ui.list.data.ListElementMoveReactor;
import de.duehl.twosidecommander.ui.list.element.ListElementDisplayer;

public class Test2ListElementDisplayerTesterWithButton extends NonModalFrameDialogBase {

    private static final String TITLE = "ListElementDisplayer-Test";

    private static final Dimension DIALOG_DIMENSION = new Dimension(1000, 600);


    private ListElementDisplayer displayer;

    private boolean hideOrShowMoveButtons;

    public Test2ListElementDisplayerTesterWithButton() {
        super(TITLE, DIALOG_DIMENSION);

        createListElementDisplayer();
        fillDialog();
    }

    private void createListElementDisplayer() {
        displayer = new DemoListElementDisplayer(createListElementMoveReactor(), "Demo-Element");

        displayer.showMoveButtonsOnListElements(true); // TODO ohne das funktioniert es nicht...
        hideOrShowMoveButtons = true;                  // Und mit dem wird der Platz nicht freigegeben.
        /*
         * Da muss ich einen anderen Test bauen, mit einer eigenen Klasse statt ListElementDisplayer
         * ohne Vererbung ....
         */

        displayer.setListElementDisplayerClickReactor(
                aListElementDisplayer -> clickedOnListElement(aListElementDisplayer));
    }

    private ListElementMoveReactor createListElementMoveReactor() {
        return new ListElementMoveReactor() {
            @Override
            public boolean canListElementMoveUp(ListElementDisplayer displayer) {
                return true;
            }
            @Override
            public boolean canListElementMoveDown(ListElementDisplayer displayer) {
                return true;
            }
            @Override
            public void moveListElementToFirst(ListElementDisplayer displayer) {
                System.out.println("nach ganz oben");
            }
            @Override
            public void moveListElementUp(ListElementDisplayer displayer) {
                System.out.println("nach oben");
            }
            @Override
            public void moveListElementDown(ListElementDisplayer displayer) {
                System.out.println("nach unten");
            }
            @Override
            public void moveListElementToLast(ListElementDisplayer displayer) {
                System.out.println("nach ganz unten");
            }
        };
    }

    private void clickedOnListElement(ListElementDisplayer aListElementDisplayer) {
        DemoListElementDisplayer demoDiscplayer =
                DemoListElementDisplayer.castListElementDisplayer(aListElementDisplayer);
        String text = demoDiscplayer.getText();
        System.out.println("Links-Klick auf Element '" + text + "'!");
    }

    @Override
    protected void populateDialog() {
        add(displayer.getPanel(), BorderLayout.CENTER);
        add(createButtonPart(), BorderLayout.SOUTH);
    }

    private Component createButtonPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createSwitchMoveButtonsButton(), BorderLayout.EAST);

        return panel;
    }

    private Component createSwitchMoveButtonsButton() {
        JButton button = new JButton("Move-Buttons ein/aus schalten");
        button.addActionListener(e -> switchMoveButtons());
        return button;
    }

    private void switchMoveButtons() {
        hideOrShowMoveButtons = !hideOrShowMoveButtons;
        displayer.showMoveButtonsOnListElements(hideOrShowMoveButtons);
        repaint();
        pack();
    }

    public static void main(String[] args) {
        Test2ListElementDisplayerTesterWithButton tester = new Test2ListElementDisplayerTesterWithButton();
        tester.setVisible(true);
    }

}
